/*
 * Decompiled with CFR 0.152.
 */
package generation;

import java.io.FileOutputStream;
import java.io.IOException;

public class SparseLUGeneration {
    public static int N;
    public static final int M = 2;
    private static double[][][] A;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: sparselu <MatrixSize> <A.in> <A.out>");
            System.exit(-1);
        }
        N = Integer.parseInt(args[0]);
        String path_A_in = args[1];
        String path_A_out = args[2];
        System.out.println("[LOG] Running with the following parameters:");
        System.out.println("[LOG]  - N: " + N);
        System.out.println("[LOG]  - M: 2");
        System.out.println("[LOG] Initializing A Matrix");
        SparseLUGeneration.initialise();
        System.out.println("[LOG] Storing A.in Matrix");
        SparseLUGeneration.storeMatrix(path_A_in);
        System.out.println("[LOG] Computing SparseLU algorithm on A");
        for (int kk = 0; kk < N; ++kk) {
            SparseLUGeneration.lu0(A[kk][kk]);
            for (int jj = kk + 1; jj < N; ++jj) {
                if (A[kk][jj] == null) continue;
                SparseLUGeneration.fwd(A[kk][kk], A[kk][jj]);
            }
            for (int ii = kk + 1; ii < N; ++ii) {
                if (A[ii][kk] == null) continue;
                SparseLUGeneration.bdiv(A[kk][kk], A[ii][kk]);
                for (int jj = kk + 1; jj < N; ++jj) {
                    if (A[kk][jj] == null) continue;
                    if (A[ii][jj] == null) {
                        SparseLUGeneration.A[ii][jj] = SparseLUGeneration.bmodAlloc(A[ii][kk], A[kk][jj]);
                        continue;
                    }
                    SparseLUGeneration.bmod(A[ii][kk], A[kk][jj], A[ii][jj]);
                }
            }
        }
        System.out.println("[LOG] Storing A.out Matrix");
        SparseLUGeneration.storeMatrix(path_A_out);
        System.out.println("[LOG] Main program finished");
    }

    private static void initialise() {
        A = new double[N][N][];
        for (int ii = 0; ii < N; ++ii) {
            for (int jj = 0; jj < N; ++jj) {
                SparseLUGeneration.A[ii][jj] = (double[])(SparseLUGeneration.isNull(ii, jj) ? null : SparseLUGeneration.initBlock(ii, jj));
            }
        }
    }

    private static boolean isNull(int ii, int jj) {
        boolean nullEntry = false;
        if (ii < jj && ii % 3 != 0) {
            nullEntry = true;
        }
        if (ii > jj && jj % 3 != 0) {
            nullEntry = true;
        }
        if (ii % 2 == 1) {
            nullEntry = true;
        }
        if (jj % 2 == 1) {
            nullEntry = true;
        }
        if (ii == jj) {
            nullEntry = false;
        }
        if (ii == jj - 1) {
            nullEntry = false;
        }
        if (ii - 1 == jj) {
            nullEntry = false;
        }
        return nullEntry;
    }

    private static double[] initBlock(int ii, int jj) {
        double[] block = new double[4];
        if (!SparseLUGeneration.isNull(ii, jj)) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    block[i * 2 + j] = Math.random() * 100.0;
                }
            }
        }
        return block;
    }

    private static void lu0(double[] diag) {
        int M = (int)Math.sqrt(diag.length);
        for (int k = 0; k < M; ++k) {
            for (int i = k + 1; i < M; ++i) {
                int n = i * M + k;
                diag[n] = diag[n] / diag[k * M + k];
                for (int j = k + 1; j < M; ++j) {
                    int n2 = i * M + j;
                    diag[n2] = diag[n2] - diag[i * M + k] * diag[k * M + j];
                }
            }
        }
    }

    private static void bdiv(double[] diag, double[] row) {
        int M = (int)Math.sqrt(diag.length);
        for (int i = 0; i < M; ++i) {
            for (int k = 0; k < M; ++k) {
                int n = i * M + k;
                row[n] = row[n] / diag[k * M + k];
                for (int j = k + 1; j < M; ++j) {
                    int n2 = i * M + j;
                    row[n2] = row[n2] - row[i * M + k] * diag[k * M + j];
                }
            }
        }
    }

    private static void bmod(double[] row, double[] col, double[] inner) {
        int M = (int)Math.sqrt(row.length);
        for (int i = 0; i < M; ++i) {
            for (int j = 0; j < M; ++j) {
                for (int k = 0; k < M; ++k) {
                    int n = i * M + j;
                    inner[n] = inner[n] - row[i * M + k] * col[k * M + j];
                }
            }
        }
    }

    private static void fwd(double[] diag, double[] col) {
        int M = (int)Math.sqrt(diag.length);
        for (int j = 0; j < M; ++j) {
            for (int k = 0; k < M; ++k) {
                for (int i = k + 1; i < M; ++i) {
                    int n = i * M + j;
                    col[n] = col[n] - diag[i * M + k] * col[k * M + j];
                }
            }
        }
    }

    private static double[] bmodAlloc(double[] row, double[] col) {
        int i;
        int M = (int)Math.sqrt(row.length);
        double[] inner = new double[M * M];
        for (i = 0; i < inner.length; ++i) {
            inner[i] = 0.0;
        }
        for (i = 0; i < M; ++i) {
            for (int j = 0; j < M; ++j) {
                for (int k = 0; k < M; ++k) {
                    int n = i * M + j;
                    inner[n] = inner[n] - row[i * M + k] * col[k * M + j];
                }
            }
        }
        return inner;
    }

    private static void storeMatrix(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    if (A[i][j] == null) {
                        fos.write("null\n".getBytes());
                        continue;
                    }
                    for (int k = 0; k < 4; ++k) {
                        String value = String.valueOf(A[i][j][k]) + " ";
                        fos.write(value.getBytes());
                    }
                    fos.write("\n".getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }
}

