/*
 * Decompiled with CFR 0.152.
 */
package sparseLU.files;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class Block {
    public static final int BLOCK_SIZE = 2;
    private int bCols;
    private int bRows;
    private double[][] data;

    public Block() {
        this.bCols = 2;
        this.bRows = 2;
        this.data = new double[this.bRows][this.bCols];
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public Block(int _bRows, int _bCols) {
        this.bRows = _bRows;
        this.bCols = _bCols;
        this.data = new double[this.bRows][this.bCols];
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                this.data[i][j] = 0.0;
            }
        }
    }

    public Block(String filename) {
        this.bCols = 2;
        this.bRows = 2;
        this.data = new double[this.bRows][this.bCols];
        try {
            FileReader filereader = new FileReader(filename);
            BufferedReader br = new BufferedReader(filereader);
            for (int i = 0; i < this.bRows; ++i) {
                String nextLine = br.readLine();
                StringTokenizer tokens = new StringTokenizer(nextLine);
                for (int j = 0; j < this.bCols && tokens.hasMoreTokens(); ++j) {
                    this.data[i][j] = Double.parseDouble(tokens.nextToken());
                }
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    protected void printBlock() {
        for (int i = 0; i < this.bRows; ++i) {
            for (int j = 0; j < this.bCols; ++j) {
                System.out.print(this.data[i][j] + " ");
            }
            System.out.println();
        }
    }

    public void blockToDisk(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            for (int i = 0; i < this.bRows; ++i) {
                for (int j = 0; j < this.bCols; ++j) {
                    String str = new Double(this.data[i][j]).toString() + " ";
                    fos.write(str.getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public void lu0() {
        for (int k = 0; k < 2; ++k) {
            for (int i = k + 1; i < 2; ++i) {
                this.data[i][k] = this.data[i][k] / this.data[k][k];
                for (int j = k + 1; j < 2; ++j) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] - this.data[i][k] * this.data[k][j];
                }
            }
        }
    }

    public void bdiv(Block diag) {
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 2; ++k) {
                this.data[i][k] = this.data[i][k] / diag.data[k][k];
                for (int j = k + 1; j < 2; ++j) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] - this.data[i][k] * diag.data[k][j];
                }
            }
        }
    }

    public void bmod(Block row, Block col) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] - row.data[i][k] * col.data[k][j];
                }
            }
        }
    }

    public void fwd(Block diag) {
        for (int j = 0; j < 2; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (int i = k + 1; i < 2; ++i) {
                    double[] dArray = this.data[i];
                    int n = j;
                    dArray[n] = dArray[n] - diag.data[i][k] * this.data[k][j];
                }
            }
        }
    }
}

