/*
 * Decompiled with CFR 0.152.
 */
package sparseLU.arrays;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import sparseLU.arrays.SparseLUImpl;

public class SparseLU {
    public static final int N = 16;
    public static final int M = 2;
    private static double[][][] _A;
    private static double[][][] _A_OUT_EXPECTED;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: sparselu <A.in> <AExpected.out>");
            System.exit(-1);
        }
        String path_A_in = args[0];
        String path_A_out = args[1];
        System.out.println("[LOG] Running with the following parameters:");
        System.out.println("[LOG]  - N: 16");
        System.out.println("[LOG]  - M: 2");
        System.out.println("[LOG] Initializing Matrix from file");
        _A = new double[16][16][4];
        SparseLU.loadMat(_A, path_A_in);
        System.out.println("[LOG] Computing SparseLU algorithm on A");
        for (int kk = 0; kk < 16; ++kk) {
            SparseLUImpl.lu0(_A[kk][kk]);
            for (int jj = kk + 1; jj < 16; ++jj) {
                if (_A[kk][jj] == null) continue;
                SparseLUImpl.fwd(_A[kk][kk], _A[kk][jj]);
            }
            for (int ii = kk + 1; ii < 16; ++ii) {
                if (_A[ii][kk] == null) continue;
                SparseLUImpl.bdiv(_A[kk][kk], _A[ii][kk]);
                for (int jj = kk + 1; jj < 16; ++jj) {
                    if (_A[kk][jj] == null) continue;
                    if (_A[ii][jj] == null) {
                        SparseLU._A[ii][jj] = SparseLUImpl.bmodAlloc(_A[ii][kk], _A[kk][jj]);
                        continue;
                    }
                    SparseLUImpl.bmod(_A[ii][kk], _A[kk][jj], _A[ii][jj]);
                }
            }
        }
        System.out.println("[LOG] Loading output matrix file expected");
        _A_OUT_EXPECTED = new double[16][16][4];
        SparseLU.loadMat(_A_OUT_EXPECTED, path_A_out);
        System.out.println("[LOG] Checking that result is correct");
        for (int i = 0; i < _A_OUT_EXPECTED.length; ++i) {
            for (int j = 0; j < _A_OUT_EXPECTED[i].length; ++j) {
                if (_A_OUT_EXPECTED[i][j] == null) {
                    if (_A[i][j] == null) continue;
                    System.out.println("[ERROR] Matrix values do not match. GOT a value. EXPECTED: null");
                    System.exit(-1);
                    continue;
                }
                for (int k = 0; k < _A_OUT_EXPECTED[i][j].length; ++k) {
                    if (_A[i][j][k] == _A_OUT_EXPECTED[i][j][k]) continue;
                    System.out.println("[ERROR] Matrix values do not match. GOT: " + _A[i][j][k] + " EXPECTED: " + _A_OUT_EXPECTED[i][j][k]);
                    System.exit(-1);
                }
            }
        }
        System.out.println("[SUCCESS] All values match.");
    }

    private static void loadMat(double[][][] mat, String fileName) {
        try {
            FileReader filereader = new FileReader(fileName);
            BufferedReader br = new BufferedReader(filereader);
            for (int row = 0; row < 16; ++row) {
                String nextLine;
                for (int col = 0; col < 16; ++col) {
                    nextLine = br.readLine();
                    StringTokenizer tokens = new StringTokenizer(nextLine);
                    boolean empty = false;
                    for (int block = 0; block < 4 && !empty && tokens.hasMoreTokens(); ++block) {
                        String value = tokens.nextToken();
                        if (value.equals("null")) {
                            mat[row][col] = null;
                            empty = true;
                            continue;
                        }
                        mat[row][col][block] = Double.parseDouble(value);
                    }
                }
                nextLine = br.readLine();
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    private static void printMatrix(double[][][] matrix, String name) {
        System.out.println("MATRIX " + name + ":");
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                SparseLUImpl.printBlock(matrix[i][j], 2);
            }
            System.out.println("");
        }
    }
}

