/*
 * Decompiled with CFR 0.152.
 */
package sparseLU.files;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import sparseLU.files.SparseLUAppException;
import sparseLU.files.SparseLUImpl;

public class SparseLU {
    public static final int N = 16;
    public static final int BLOCK_SIZE = 2;
    private static boolean[][] matriu;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: sparselu <A.in> <AGot.out>");
            System.exit(-1);
        }
        String path_A_in = args[0];
        String path_A_out = args[1];
        System.out.println("[LOG] Running with the following parameters:");
        System.out.println("[LOG]  - N: 16");
        System.out.println("[LOG]  - M: 2");
        System.out.println("[LOG] Initializing Matrix from file");
        matriu = new boolean[16][16];
        SparseLU.loadInitialMat(path_A_in);
        System.out.println("[LOG] Computing SparseLU algorithm on A");
        try {
            for (int k = 0; k < 16; ++k) {
                String file = "A." + k + "." + k;
                SparseLUImpl.lu0(file);
                for (int j = k + 1; j < 16; ++j) {
                    if (!matriu[k][j]) continue;
                    String file1 = "A." + k + "." + j;
                    SparseLUImpl.fwd(file, file1);
                }
                for (int i = k + 1; i < 16; ++i) {
                    if (!matriu[i][k]) continue;
                    String file2 = "A." + i + "." + k;
                    SparseLUImpl.bdiv(file, file2);
                    for (int j = k + 1; j < 16; ++j) {
                        if (!matriu[k][j]) continue;
                        String file3 = "A." + k + "." + j;
                        String file4 = "A." + i + "." + j;
                        if (!matriu[i][j]) {
                            SparseLU.matriu[i][j] = true;
                        }
                        SparseLUImpl.bmod(file2, file3, file4);
                    }
                }
            }
        }
        catch (SparseLUAppException se) {
            System.out.println("[ERROR] Error computing SPARSELU algorithm");
            System.exit(-1);
        }
        System.out.println("[LOG] Storing output matrix file obtained");
        SparseLU.storeMatrix(path_A_out);
        System.out.println("[LOG] Main program finished. Result needs to be checked (script).");
    }

    private static void loadInitialMat(String fileName) {
        double[][][] m = SparseLU.loadFileToArray(fileName);
        for (int i = 0; i < m.length; ++i) {
            for (int j = 0; j < m[i].length; ++j) {
                String name = "A." + i + "." + j;
                try {
                    FileOutputStream fos = new FileOutputStream(name);
                    for (int i_block = 0; i_block < 2; ++i_block) {
                        for (int j_block = 0; j_block < 2; ++j_block) {
                            if (m[i][j] != null) {
                                SparseLU.matriu[i][j] = true;
                                String str = String.valueOf(m[i][j][i_block * 2 + j_block]) + " ";
                                fos.write(str.getBytes());
                                continue;
                            }
                            SparseLU.matriu[i][j] = false;
                            fos.write("0.0 ".getBytes());
                        }
                        fos.write("\n".getBytes());
                    }
                    fos.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    System.out.println("[ERROR] Error loading input file.");
                    System.exit(-1);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("[ERROR] Error loading input file.");
                    System.exit(-1);
                }
            }
        }
    }

    private static double[][][] loadFileToArray(String fileName) {
        double[][][] mat = new double[16][16][4];
        try {
            FileReader filereader = new FileReader(fileName);
            BufferedReader br = new BufferedReader(filereader);
            for (int row = 0; row < 16; ++row) {
                String nextLine;
                for (int col = 0; col < 16; ++col) {
                    nextLine = br.readLine();
                    StringTokenizer tokens = new StringTokenizer(nextLine);
                    boolean empty = false;
                    for (int block = 0; block < 4 && !empty && tokens.hasMoreTokens(); ++block) {
                        String value = tokens.nextToken();
                        if (value.equals("null")) {
                            mat[row][col] = null;
                            empty = true;
                            continue;
                        }
                        mat[row][col][block] = Double.parseDouble(value);
                    }
                }
                nextLine = br.readLine();
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
        return mat;
    }

    private static void storeMatrix(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    if (!matriu[i][j]) {
                        fos.write("null\n".getBytes());
                        continue;
                    }
                    String blockName = "A." + i + "." + j;
                    FileReader filereader = new FileReader(blockName);
                    BufferedReader br = new BufferedReader(filereader);
                    for (int iblock = 0; iblock < 2; ++iblock) {
                        String nextLine = br.readLine();
                        StringTokenizer tokens = new StringTokenizer(nextLine);
                        for (int jblock = 0; jblock < 2 && tokens.hasMoreTokens(); ++jblock) {
                            String value = tokens.nextToken() + " ";
                            fos.write(value.getBytes());
                        }
                    }
                    br.close();
                    filereader.close();
                    fos.write("\n".getBytes());
                }
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }
}

