/*
 * Decompiled with CFR 0.152.
 */
package sparseLU.objects;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import sparseLU.objects.Block;

public class SparseLU {
    private static final int N = 16;
    private static final int M = 2;
    private static Block[][] A;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: sparselu <A.in> <AExpected.out>");
            System.exit(-1);
        }
        String path_A_in = args[0];
        String path_A_out = args[1];
        System.out.println("[LOG] Running with the following parameters:");
        System.out.println("[LOG]  - N: 16");
        System.out.println("[LOG]  - M: 2");
        System.out.println("[LOG] Initializing Matrix from file");
        A = new Block[16][16];
        SparseLU.loadMat(A, path_A_in);
        for (int kk = 0; kk < 16; ++kk) {
            A[kk][kk].lu0();
            for (int jj = kk + 1; jj < 16; ++jj) {
                if (A[kk][jj] == null) continue;
                A[kk][jj].fwd(A[kk][kk]);
            }
            for (int ii = kk + 1; ii < 16; ++ii) {
                if (A[ii][kk] == null) continue;
                A[ii][kk].bdiv(A[kk][kk]);
                for (int jj = kk + 1; jj < 16; ++jj) {
                    if (A[kk][jj] == null) continue;
                    if (A[ii][jj] == null) {
                        SparseLU.A[ii][jj] = Block.bmodAlloc(A[ii][kk], A[kk][jj]);
                        continue;
                    }
                    A[ii][jj].bmod(A[ii][kk], A[kk][jj]);
                }
            }
        }
        System.out.println("[LOG] Loading output matrix file expected");
        Block[][] A_OUT_EXPECTED = new Block[16][16];
        SparseLU.loadMat(A_OUT_EXPECTED, path_A_out);
        System.out.println("[LOG] Checking that result is correct");
        for (int i = 0; i < A_OUT_EXPECTED.length; ++i) {
            for (int j = 0; j < A_OUT_EXPECTED[i].length; ++j) {
                if (A_OUT_EXPECTED[i][j] == null) {
                    if (A[i][j] == null) continue;
                    System.out.println("[ERROR] Matrix values do not match. GOT a value. EXPECTED: null");
                    System.exit(-1);
                    continue;
                }
                for (int i_block = 0; i_block < A_OUT_EXPECTED[i][j].getData().length; ++i_block) {
                    for (int j_block = 0; j_block < A_OUT_EXPECTED[i][j].getData()[i_block].length; ++j_block) {
                        if (A[i][j].getData()[i_block][j_block] == A_OUT_EXPECTED[i][j].getData()[i_block][j_block]) continue;
                        System.out.println("[ERROR] Matrix values do not match. GOT: " + A[i][j].getData()[i_block][j_block] + " EXPECTED: " + A_OUT_EXPECTED[i][j].getData()[i_block][j_block]);
                        System.exit(-1);
                    }
                }
            }
        }
        System.out.println("[SUCCESS] All values match.");
    }

    private static void loadMat(Block[][] mat, String fileName) {
        try {
            FileReader filereader = new FileReader(fileName);
            BufferedReader br = new BufferedReader(filereader);
            for (int row = 0; row < 16; ++row) {
                String nextLine;
                for (int col = 0; col < 16; ++col) {
                    nextLine = br.readLine();
                    StringTokenizer tokens = new StringTokenizer(nextLine);
                    boolean empty = false;
                    double[][] aux = new double[2][2];
                    for (int i_block = 0; i_block < 2 && !empty && tokens.hasMoreTokens(); ++i_block) {
                        for (int j_block = 0; j_block < 2 && !empty && tokens.hasMoreTokens(); ++j_block) {
                            String value = tokens.nextToken();
                            if (value.equals("null")) {
                                aux = null;
                                empty = true;
                                continue;
                            }
                            aux[i_block][j_block] = Double.parseDouble(value);
                        }
                    }
                    if (aux != null) {
                        Block aux2 = new Block(2);
                        aux2.setData(aux);
                        mat[row][col] = aux2;
                        continue;
                    }
                    mat[row][col] = null;
                }
                nextLine = br.readLine();
            }
            br.close();
            filereader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printMatrix(Block[][] matrix, String name) {
        System.out.println("MATRIX " + name + ":");
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (matrix[i][j] == null) {
                    System.out.println("null");
                    continue;
                }
                matrix[i][j].printBlock();
            }
        }
    }
}

