/*
 * Decompiled with CFR 0.152.
 */
package testBinary;

import binary.BINARY;
import es.bsc.compss.api.COMPSs;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Main {
    public static void main(String[] args) throws Exception {
        BINARY.pwdEmpty();
        COMPSs.barrier();
        Integer ev = BINARY.pwdExitValue();
        System.out.println("EXIT VALUE: " + ev);
        if (ev != 0) {
            throw new Exception("ERROR: Invalid binary exit value");
        }
        BINARY.pwdWorkingDir();
        COMPSs.barrier();
        int n = 3;
        String msg = "Hello World!";
        String fileName = "my_file.in";
        Main.writeFileContent("my_file.in", 1);
        BINARY.customParams(n, "Hello World!", "my_file.in");
        COMPSs.barrier();
        String stdout = "pwd_working_dir.stdout";
        String stderr = "pwd_working_dir.stderr";
        BINARY.pwdWorkingDirStd("pwd_working_dir.stdout", "pwd_working_dir.stderr");
        System.out.println("STDOUT:");
        Main.printFileContent("pwd_working_dir.stdout");
        System.out.println("STDERR:");
        Main.printFileContent("pwd_working_dir.stderr");
    }

    private static void writeFileContent(String filename, int value) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(filename);){
            fos.write(value);
        }
        catch (IOException ioe) {
            throw new Exception("[ERROR] Error initializing file: " + filename, ioe);
        }
    }

    private static void printFileContent(String filename) throws Exception {
        System.out.println("- FILE: " + filename);
        System.out.println("- CONTENT:");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException ioe) {
            throw new Exception("[ERROR] Error reading file " + filename, ioe);
        }
    }
}

