/*
 * Decompiled with CFR 0.152.
 */
package testCommutative;

import es.bsc.compss.api.COMPSs;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import model.MyFile;
import testCommutative.TestCommutativeImpl;

public class TestCommutative {
    public static final String FILE_NAME1 = "/tmp/sharedDisk/file1.txt";
    public static final String FILE_NAME2 = "/tmp/sharedDisk/file2.txt";
    public static final String FILE_NAME3 = "/tmp/sharedDisk/file3.txt";
    public static final String FILE_NAME4 = "/tmp/sharedDisk/file4.txt";
    public static final String FILE_NAME5 = "/tmp/sharedDisk/file5.txt";
    public static final String FILE_NAME6 = "/tmp/sharedDisk/file6.txt";
    public static final String FILE_NAME7 = "/tmp/sharedDisk/file7.txt";
    public static final String FILE_NAME8 = "/tmp/sharedDisk/file8.txt";
    public static final String FILE_NAME9 = "/tmp/sharedDisk/file9.txt";
    public static final int N = 3;
    public static final int M = 4;
    public static final int MAX_AVAILABLE = 1;

    public static void main(String[] args) throws Exception {
        System.out.println("[LOG] Test task creation commutative");
        TestCommutative.testTaskCreationCommutative();
        System.out.println("[LOG] Test DIRECTION COMMUTATIVE");
        TestCommutative.testDirectionCommutative();
        System.out.println("[LOG] Test PSCO INOUT-CONCURRENT");
        TestCommutative.testPSCOINOUTConcurrent();
        System.out.println("[LOG] Test PSCO CONCURRENT-INOUT");
        TestCommutative.testPSCOCommutativeINOUT();
    }

    private static void testTaskCreationCommutative() throws Exception {
        Integer[] a = new Integer[5];
        TestCommutative.newFile(FILE_NAME9, true);
        TestCommutativeImpl.writeOne(FILE_NAME9);
        for (int i = 1; i < 5; ++i) {
            a[i] = TestCommutativeImpl.task(i);
            TestCommutativeImpl.reduce_and_check_task(FILE_NAME9, a[i]);
            System.out.println("Round " + i);
        }
        TestCommutativeImpl.readFile(FILE_NAME9);
    }

    private static void testDirectionCommutative() throws Exception {
        TestCommutative.newFile(FILE_NAME1, true);
        TestCommutative.newFile(FILE_NAME2, false);
        TestCommutative.newFile(FILE_NAME3, false);
        TestCommutative.newFile(FILE_NAME4, false);
        TestCommutative.newFile(FILE_NAME5, true);
        TestCommutative.newFile(FILE_NAME6, false);
        TestCommutativeImpl.writeOne(FILE_NAME6);
        System.out.println("[LOG] Write two");
        TestCommutativeImpl.writeTwoSlow(FILE_NAME1);
        TestCommutativeImpl.writeTwoSlow(FILE_NAME2);
        System.out.println("[LOG] Write one");
        TestCommutativeImpl.writeOne(FILE_NAME3);
        TestCommutativeImpl.writeOne(FILE_NAME4);
        System.out.println("[LOG] Write commutative");
        TestCommutativeImpl.writeCommutative(FILE_NAME1, FILE_NAME2, FILE_NAME5);
        System.out.println("[LOG] Write commutative");
        TestCommutativeImpl.writeCommutative(FILE_NAME3, FILE_NAME4, FILE_NAME5);
        System.out.println("[LOG] Checking result");
        int result = TestCommutativeImpl.checkContents(FILE_NAME5);
        int M = 6;
        if (result != M) {
            throw new Exception("Incorrect number: " + result + "(expected 6)");
        }
        System.out.println("[LOG] Add one commutative");
        TestCommutativeImpl.addOneCommutative(FILE_NAME5);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeImpl.addOneCommutative(FILE_NAME5);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeImpl.addOneCommutative(FILE_NAME5);
        System.out.println("[LOG] Accumulate commutative");
        TestCommutativeImpl.accumulateCommutative(FILE_NAME5, FILE_NAME6);
        System.out.println("[LOG] Accumulate commutative");
        TestCommutativeImpl.accumulateCommutative(FILE_NAME5, FILE_NAME6);
        System.out.println("[LOG] Accumulate commutative");
        TestCommutativeImpl.accumulateCommutative(FILE_NAME5, FILE_NAME6);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeImpl.addOneCommutative(FILE_NAME6);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeImpl.addOneCommutative(FILE_NAME6);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeImpl.addOneCommutative(FILE_NAME6);
        result = TestCommutativeImpl.readFile(FILE_NAME6);
        System.out.println("The final result is " + result);
        M = 31;
        if (result != M) {
            throw new Exception("Incorrect number: " + result + "(Expected 31)");
        }
    }

    private static void testPSCOCommutativeINOUT() throws Exception {
        int i;
        TestCommutative.newFile(FILE_NAME7, true);
        String id = "myfile_" + UUID.randomUUID().toString();
        MyFile f = new MyFile(FILE_NAME7);
        f.makePersistent(id);
        for (i = 0; i < 3; ++i) {
            f.writeThree();
        }
        for (i = 0; i < 3; ++i) {
            f.writeFour();
        }
        System.out.println("Synchronizing PSCO...");
        int M = 6;
        int count = f.getCount(FILE_NAME7);
        System.out.println(count + " in first ");
        if (count != M) {
            throw new Exception("Incorrect number of writers " + count);
        }
        System.out.println("[LOG][PSCO_CONCURRENT] There have been " + count + " writers");
    }

    private static void testPSCOINOUTConcurrent() throws Exception {
        int i;
        TestCommutative.newFile(FILE_NAME8, true);
        String id = "myfile_" + UUID.randomUUID().toString();
        MyFile f = new MyFile(FILE_NAME8);
        f.makePersistent(id);
        for (i = 0; i < 3; ++i) {
            f.writeFour();
        }
        for (i = 0; i < 3; ++i) {
            f.writeThree();
        }
        int M = 6;
        int count = f.getCount(FILE_NAME8);
        System.out.println(count + " in second ");
        if (count != M) {
            throw new Exception("Incorrect number of writers " + count);
        }
        System.out.println("[LOG][PSCO_CONCURRENT] There have been " + count + " writers");
        COMPSs.barrier((boolean)false);
    }

    private static void newFile(String fileName, boolean create) throws IOException {
        boolean createdFile;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        if (create && !(createdFile = file.createNewFile())) {
            throw new IOException("[ERROR] Cannot create test file");
        }
    }
}

