/*
 * Decompiled with CFR 0.152.
 */
package storageManager;

import java.io.File;
import java.io.IOException;
import java.util.List;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;
import storageManager.Serializer;

public class StorageManager {
    private static final String PSCO_EXTENSION = ".PSCO";
    private static final String ERROR_SERIALIZE = "ERROR: Cannot serialize object to id=";
    private static final String BASE_WORKING_DIR = File.separator + "tmp" + File.separator + "PSCO" + File.separator;

    public static void persist(StubItf o) throws StorageException {
        String id = o.getID();
        if (id != null) {
            List hostnames = StorageItf.getLocations((String)id);
            for (String h : hostnames) {
                String path = BASE_WORKING_DIR + h + File.separator + id + PSCO_EXTENSION;
                try {
                    Serializer.serialize(o, path);
                }
                catch (IOException e) {
                    throw new StorageException(ERROR_SERIALIZE + id, (Exception)e);
                }
            }
        }
    }
}

