/*
 * Decompiled with CFR 0.152.
 */
package testConcurrent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import model.MyFile;
import testConcurrent.TestConcurrentImpl;

public class TestConcurrent {
    public static final String FILE_NAME1 = "/tmp/sharedDisk/file1.txt";
    public static final String FILE_NAME2 = "/tmp/sharedDisk/file2.txt";
    public static final String FILE_NAME3 = "/tmp/sharedDisk/file3.txt";
    public static final int N = 3;
    public static final int MAX_AVAILABLE = 1;

    public static void main(String[] args) throws Exception {
        System.out.println("[LOG] Test DIRECTION CONCURRENT");
        TestConcurrent.testDirectionConcurrent();
        System.out.println("[LOG] Test PSCO CONCURRENT-INOUT");
        TestConcurrent.testPSCOConcurrentINOUT();
        System.out.println("[LOG] Test PSCO INOUT-CONCURRENT");
        TestConcurrent.testPSCOINOUTConcurrent();
    }

    private static void testDirectionConcurrent() throws Exception {
        int i;
        TestConcurrent.newFile(FILE_NAME1);
        for (i = 0; i < 3; ++i) {
            System.out.println("[LOG] Write one");
            TestConcurrentImpl.writeOne(FILE_NAME1);
        }
        for (i = 0; i < 3; ++i) {
            System.out.println("[LOG] Write two");
            TestConcurrentImpl.writeTwo(FILE_NAME1);
        }
        int lines = 0;
        try (FileInputStream fis = new FileInputStream(FILE_NAME1);){
            while (fis.read() > 0) {
                ++lines;
            }
            System.out.println("Final counter value is " + lines);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        int M = 6;
        if (lines != M) {
            throw new Exception("Incorrect number of writers " + lines);
        }
    }

    private static void testPSCOConcurrentINOUT() throws Exception {
        int i;
        TestConcurrent.newFile(FILE_NAME2);
        String id = "myfile_" + UUID.randomUUID().toString();
        MyFile f = new MyFile(FILE_NAME2);
        f.makePersistent(id);
        for (i = 0; i < 3; ++i) {
            f.writeThree();
        }
        for (i = 0; i < 3; ++i) {
            f.writeFour();
        }
        System.out.println("Synchronizing PSCO...");
        int M = 6;
        int count = f.getCount(FILE_NAME2);
        if (count != M) {
            throw new Exception("Incorrect number of writers " + count);
        }
        System.out.println("[LOG][PSCO_CONCURRENT] There have been " + count + " writers");
    }

    private static void testPSCOINOUTConcurrent() throws Exception {
        int i;
        TestConcurrent.newFile(FILE_NAME3);
        String id = "myfile_" + UUID.randomUUID().toString();
        MyFile f = new MyFile(FILE_NAME3);
        f.makePersistent(id);
        for (i = 0; i < 3; ++i) {
            f.writeFour();
        }
        for (i = 0; i < 3; ++i) {
            f.writeThree();
        }
        int M = 6;
        int count = f.getCount(FILE_NAME3);
        if (count != M) {
            throw new Exception("Incorrect number of writers " + count);
        }
        System.out.println("[LOG][PSCO_CONCURRENT] There have been " + count + " writers");
    }

    private static void newFile(String fileName) throws IOException {
        boolean createdFile;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        if (!(createdFile = file.createNewFile())) {
            throw new IOException("[ERROR] Cannot create test file");
        }
    }
}

