/*
 * Decompiled with CFR 0.152.
 */
package multiImplementations;

import binary.BINARY;
import es.bsc.compss.api.COMPSs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import mpi.MPI;
import multiImplementations.Implementation1;

public class MultiImplementations {
    private static final int SLEEP_WAIT_FOR_RUNTIME = 20000;
    private static final int NUM_TESTS = 5;
    private static final String FILE_NAME = "counterFile_";

    public static void main(String[] args) {
        Throwable throwable;
        String counterName;
        int i;
        if (args.length != 2) {
            System.out.println("[ERROR] Bad number of parameters");
            System.out.println("    Usage: multiImplementations.MultiImplementations <taskWidth> <counterValue>");
            System.exit(-1);
        }
        int taskWidth = Integer.parseInt(args[0]);
        int initialValue = Integer.parseInt(args[1]);
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (i = 0; i < 5 * taskWidth; ++i) {
            counterName = FILE_NAME + i;
            System.out.println("[INFO] Initializing file " + counterName + " with value " + initialValue);
            try {
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(counterName));){
                    writer.write(String.valueOf(initialValue));
                    writer.flush();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(-1);
            }
        }
        System.out.println("[INFO] Executing METHOD-METHOD versioning");
        for (i = 0; i < taskWidth; ++i) {
            counterName = FILE_NAME + i;
            Implementation1.methodMethod(counterName);
        }
        COMPSs.barrier();
        System.out.println("[INFO] Executing METHOD-BINARY versioning");
        for (i = taskWidth; i < 2 * taskWidth; ++i) {
            counterName = FILE_NAME + i;
            Implementation1.methodBinary(counterName);
        }
        COMPSs.barrier();
        System.out.println("[INFO] Executing BINARY-METHOD versioning");
        for (i = 2 * taskWidth; i < 3 * taskWidth; ++i) {
            counterName = FILE_NAME + i;
            BINARY.binaryMethod(counterName);
        }
        COMPSs.barrier();
        System.out.println("[INFO] Executing METHOD-MPI versioning");
        for (i = 3 * taskWidth; i < 4 * taskWidth; ++i) {
            counterName = FILE_NAME + i;
            Implementation1.methodMpi(counterName);
        }
        COMPSs.barrier();
        System.out.println("[INFO] Executing MPI-METHOD versioning");
        for (i = 4 * taskWidth; i < 5 * taskWidth; ++i) {
            counterName = FILE_NAME + i;
            MPI.mpiMethod(counterName);
        }
        COMPSs.barrier();
        System.out.println("[INFO] Synchronizing values");
        for (i = 0; i < 5 * taskWidth; ++i) {
            counterName = FILE_NAME + i;
            try {
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(counterName));){
                    String strVal = reader.readLine();
                    Integer count = Integer.valueOf(strVal);
                    System.out.println("[INFO] Final counter value on file " + counterName + " is " + count);
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

