/*
 * Decompiled with CFR 0.152.
 */
package testMultiNode;

import java.util.HashMap;
import java.util.Map;

public class MainImpl {
    private static final String OMP_NUM_THREADS = "OMP_NUM_THREADS";
    private static final String COMPSS_HOSTNAMES = "COMPSS_HOSTNAMES";
    private static final String COMPSS_NUM_NODES = "COMPSS_NUM_NODES";
    private static final String COMPSS_NUM_THREADS = "COMPSS_NUM_THREADS";

    public static int multiNodeTask() {
        Integer n;
        Integer n2;
        Integer count;
        String[] expectedHosts;
        Integer expectedNumNodes = 2;
        Integer expectedNumThreads = 2;
        String expectedHostnames = "COMPSsWorker01,COMPSsWorker01,COMPSsWorker02,COMPSsWorker02";
        Integer numNodes = Integer.valueOf(System.getProperty(COMPSS_NUM_NODES));
        if (numNodes != expectedNumNodes) {
            System.err.println("ERROR: Incorrect number of nodes");
            System.err.println("  - Expected: " + expectedNumNodes);
            System.err.println("  - Got: " + numNodes);
            return 1;
        }
        Integer numThreads = Integer.valueOf(System.getProperty(COMPSS_NUM_THREADS));
        if (numThreads != expectedNumThreads) {
            System.err.println("ERROR: Incorrect number of threads");
            System.err.println("  - Expected: " + expectedNumThreads);
            System.err.println("  - Got: " + numThreads);
            return 1;
        }
        Integer OMPnumThreads = Integer.valueOf(System.getProperty(OMP_NUM_THREADS));
        if (OMPnumThreads != expectedNumThreads) {
            System.err.println("ERROR: Incorrect number of OMP threads");
            System.err.println("  - Expected: " + expectedNumThreads);
            System.err.println("  - Got: " + OMPnumThreads);
            return 1;
        }
        String hostnames = System.getProperty(COMPSS_HOSTNAMES);
        if (hostnames == null || hostnames.isEmpty()) {
            System.err.println("ERROR: Incorrect hostlist");
            System.err.println("  - No hosts obtained");
            return 1;
        }
        String[] hosts = hostnames.split(",");
        if (hosts.length != (expectedHosts = expectedHostnames.split(",")).length) {
            System.err.println("ERROR: Incorrect hostlist");
            System.err.println("  - Expected: " + expectedHosts.length + " hosts");
            System.err.println("  - Got: " + hosts.length + " hosts");
            return 1;
        }
        HashMap<String, Integer> expectedCounts = new HashMap<String, Integer>();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (String host : hosts) {
            count = (Integer)counts.get(host);
            if (count == null) {
                count = 0;
            }
            n2 = count;
            n = count = Integer.valueOf(count + 1);
            counts.put(host, count);
        }
        for (String host : expectedHosts) {
            count = (Integer)expectedCounts.get(host);
            if (count == null) {
                count = 0;
            }
            n2 = count;
            n = count = Integer.valueOf(count + 1);
            expectedCounts.put(host, count);
        }
        for (Map.Entry entry : expectedCounts.entrySet()) {
            String host = (String)entry.getKey();
            Integer expectedCount = (Integer)entry.getValue();
            if (expectedCount == (count = (Integer)counts.remove(host))) continue;
            System.err.println("ERROR: Incorrect hostlist");
            System.err.println("  - Expected: " + expectedCount + " occurrences of host " + host);
            System.err.println("  - Got: " + count + " occurrences");
        }
        if (!counts.isEmpty()) {
            System.err.println("ERROR: Incorrect hostlist");
            for (Map.Entry entry : counts.entrySet()) {
                System.err.println("  - Expecting no occurrences of host " + (String)entry.getKey());
                System.err.println("  - Got " + entry.getValue() + " occurrences");
            }
        }
        return 0;
    }
}

