/*
 * Decompiled with CFR 0.152.
 */
package testCommutativeGroups;

import es.bsc.compss.api.COMPSs;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import model.MyFile;
import testCommutativeGroups.TestCommutativeGroupsImpl;

public class TestCommutativeGroups {
    public static final String FILE_NAME1 = "/tmp/sharedDisk/CGfile1.txt";
    public static final String FILE_NAME2 = "/tmp/sharedDisk/CGfile2.txt";
    public static final String FILE_NAME3 = "/tmp/sharedDisk/CGfile3.txt";
    public static final String FILE_NAME4 = "/tmp/sharedDisk/CGfile4.txt";
    public static final String FILE_NAME5 = "/tmp/sharedDisk/CGfile5.txt";
    public static final String FILE_NAME6 = "/tmp/sharedDisk/CGfile6.txt";
    public static final String FILE_NAME7 = "/tmp/sharedDisk/CGfile7.txt";
    public static final String FILE_NAME8 = "/tmp/sharedDisk/CGfile8.txt";
    public static final String FILE_NAME9 = "/tmp/sharedDisk/CGfile9.txt";
    public static final int N = 3;
    public static final int M = 4;
    public static final int MAX_AVAILABLE = 1;

    public static void main(String[] args) throws Exception {
        System.out.println("[LOG] Test task creation commutative");
        TestCommutativeGroups.testTaskCreationCommutative();
        System.out.println("[LOG] Test DIRECTION COMMUTATIVE");
        TestCommutativeGroups.testDirectionCommutative();
        System.out.println("[LOG] Test PSCO INOUT-CONCURRENT");
        TestCommutativeGroups.testPSCOINOUTCommutative();
        System.out.println("[LOG] Test PSCO CONCURRENT-INOUT");
        TestCommutativeGroups.testPSCOCommutativeINOUT();
    }

    private static void testTaskCreationCommutative() throws Exception {
        Integer[] a = new Integer[5];
        TestCommutativeGroups.newFile(FILE_NAME9, true);
        TestCommutativeGroupsImpl.writeOne(FILE_NAME9);
        for (int i = 1; i < 5; ++i) {
            a[i] = TestCommutativeGroupsImpl.task(i);
            TestCommutativeGroupsImpl.reduce_and_check_task(FILE_NAME9, a[i]);
            System.out.println("Round " + i);
        }
        TestCommutativeGroupsImpl.readFile(FILE_NAME9);
    }

    private static void testDirectionCommutative() throws Exception {
        TestCommutativeGroups.newFile(FILE_NAME1, false);
        TestCommutativeGroups.newFile(FILE_NAME2, false);
        TestCommutativeGroups.newFile(FILE_NAME3, false);
        TestCommutativeGroups.newFile(FILE_NAME4, false);
        TestCommutativeGroups.newFile(FILE_NAME5, true);
        TestCommutativeGroups.newFile(FILE_NAME6, false);
        TestCommutativeGroupsImpl.writeOne(FILE_NAME6);
        System.out.println("[LOG] Write two");
        TestCommutativeGroupsImpl.writeTwoSlow(FILE_NAME1);
        TestCommutativeGroupsImpl.writeTwoSlow(FILE_NAME2);
        System.out.println("[LOG] Write one");
        TestCommutativeGroupsImpl.writeOne(FILE_NAME3);
        TestCommutativeGroupsImpl.writeOne(FILE_NAME4);
        System.out.println("[LOG] Write commutative");
        TestCommutativeGroupsImpl.writeCommutative(FILE_NAME1, FILE_NAME2, FILE_NAME5);
        System.out.println("[LOG] Write commutative");
        TestCommutativeGroupsImpl.writeCommutative(FILE_NAME3, FILE_NAME4, FILE_NAME5);
        System.out.println("[LOG] Checking result");
        int result = TestCommutativeGroupsImpl.checkContents(FILE_NAME5);
        int M = 6;
        if (result != M) {
            throw new Exception("Incorrect number: " + result + "(expected 6)");
        }
        System.out.println("[LOG] Add one commutative");
        TestCommutativeGroupsImpl.addOneCommutative(FILE_NAME5);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeGroupsImpl.addOneCommutative(FILE_NAME5);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeGroupsImpl.addOneCommutative(FILE_NAME5);
        System.out.println("[LOG] Accumulate commutative");
        TestCommutativeGroupsImpl.accumulateCommutative(FILE_NAME5, FILE_NAME6);
        System.out.println("[LOG] Accumulate commutative");
        TestCommutativeGroupsImpl.accumulateCommutative(FILE_NAME5, FILE_NAME6);
        System.out.println("[LOG] Accumulate commutative");
        TestCommutativeGroupsImpl.accumulateCommutative(FILE_NAME5, FILE_NAME6);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeGroupsImpl.addOneCommutative(FILE_NAME6);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeGroupsImpl.addOneCommutative(FILE_NAME6);
        System.out.println("[LOG] Add one commutative");
        TestCommutativeGroupsImpl.addOneCommutative(FILE_NAME6);
        result = TestCommutativeGroupsImpl.readFile(FILE_NAME6);
        System.out.println("The final result is " + result);
        M = 31;
        if (result != M) {
            throw new Exception("Incorrect number: " + result + "(Expected 31)");
        }
    }

    private static void testPSCOCommutativeINOUT() throws Exception {
        int i;
        TestCommutativeGroups.newFile(FILE_NAME7, true);
        String id = "myfile_" + UUID.randomUUID().toString();
        MyFile f = new MyFile(FILE_NAME7);
        f.makePersistent(id);
        for (i = 0; i < 3; ++i) {
            f.writeThree();
        }
        for (i = 0; i < 3; ++i) {
            f.writeFour();
        }
        System.out.println("Synchronizing PSCO...");
        int M = 6;
        int count = f.getCount(FILE_NAME7);
        System.out.println(count + " in first ");
        if (count != M) {
            throw new Exception("Incorrect number of writers " + count);
        }
        System.out.println("[LOG][PSCO_COMMUTATIVE] There have been " + count + " writers");
    }

    private static void testPSCOINOUTCommutative() throws Exception {
        int i;
        TestCommutativeGroups.newFile(FILE_NAME8, true);
        String id = "myfile_" + UUID.randomUUID().toString();
        MyFile f = new MyFile(FILE_NAME8);
        f.makePersistent(id);
        for (i = 0; i < 3; ++i) {
            f.writeFour();
        }
        for (i = 0; i < 3; ++i) {
            f.writeThree();
        }
        int M = 6;
        int count = f.getCount(FILE_NAME8);
        System.out.println(count + " in second ");
        if (count != M) {
            throw new Exception("Incorrect number of writers " + count);
        }
        System.out.println("[LOG][PSCO_COMMUTATIVE] There have been " + count + " writers");
        COMPSs.barrier((boolean)false);
    }

    private static void newFile(String fileName, boolean create) throws IOException {
        boolean createdFile;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        if (create && !(createdFile = file.createNewFile())) {
            throw new IOException("[ERROR] Cannot create test file");
        }
    }
}

