/*
 * Decompiled with CFR 0.152.
 */
package testCOMPSsExceptions;

import es.bsc.compss.api.COMPSs;
import es.bsc.compss.api.COMPSsGroup;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;
import java.io.IOException;
import testCOMPSsExceptions.TestCOMPSsExceptionsImpl;

public class TestCOMPSsExceptions {
    public static final int N = 3;
    public static final int M = 4;
    public static final int MAX_AVAILABLE = 1;
    public static final String FILE_NAME = "/tmp/sharedDisk/taskGroups.txt";

    public static void main(String[] args) throws Exception {
        TestCOMPSsExceptions.newFile(FILE_NAME, true);
        System.out.println("[LOG] Test task group exceptions");
        TestCOMPSsExceptions.testGroupExceptions();
        System.out.println("[LOG] Test task group exceptions");
        TestCOMPSsExceptions.testGroupExceptionsBarrier();
        COMPSs.getFile((String)FILE_NAME);
    }

    private static void testGroupExceptions() throws InterruptedException {
        try (COMPSsGroup a = new COMPSsGroup("FailedGroup", true);){
            System.out.println("Executing write One ");
            for (int j = 0; j < 3; ++j) {
                TestCOMPSsExceptionsImpl.writeOne(FILE_NAME);
            }
        }
        catch (COMPSsException e) {
            TestCOMPSsExceptionsImpl.writeThree(FILE_NAME);
            System.out.println("Exception caught!!");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            TestCOMPSsExceptionsImpl.writeFour(FILE_NAME);
        }
    }

    private static void testGroupExceptionsBarrier() throws InterruptedException {
        try (COMPSsGroup a = new COMPSsGroup("FailedGroup2", false);){
            System.out.println("Executing write One ");
            for (int j = 0; j < 3; ++j) {
                TestCOMPSsExceptionsImpl.writeOne(FILE_NAME);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            COMPSs.barrierGroup((String)"FailedGroup2");
        }
        catch (COMPSsException e) {
            System.out.println("Exception caught in barrier!!");
            TestCOMPSsExceptionsImpl.writeThree(FILE_NAME);
        }
        finally {
            TestCOMPSsExceptionsImpl.writeFour(FILE_NAME);
        }
    }

    private static void newFile(String fileName, boolean create) throws IOException {
        boolean createdFile;
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        if (create && !(createdFile = file.createNewFile())) {
            throw new IOException("[ERROR] Cannot create test file");
        }
    }
}

