/*
 * Decompiled with CFR 0.152.
 */
package cloudManager;

import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ResourceManager;

public class Test {
    private static final int WAIT_FOR_RUNTIME_TIME = 10000;
    private static int coreCount;

    public static void main(String[] args) {
        System.out.println("[LOG] Waiting for Runtime to be loaded");
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[LOG] Running Cloud Manager Test");
        Test.cloudManagerTest();
    }

    private static void cloudManagerTest() {
        System.out.println("[LOG] CloudManager Static Structures definition");
        coreCount = CoreManager.getCoreCount();
        CloudProvider cp = ResourceManager.getCloudProvider((String)"BSC");
        for (int coreId = 0; coreId < coreCount; ++coreId) {
            System.out.println("[LOG] Checking Core" + coreId);
            for (Implementation impl : CoreManager.getCoreImplementations((int)coreId)) {
                String error;
                String res;
                if (!impl.getTaskType().equals((Object)Implementation.TaskType.METHOD)) continue;
                System.out.println("[LOG]\t Checking Implementation: " + impl.getImplementationId());
                System.out.println("\t\t Checking obtained compatible cloud images");
                MethodImplementation mImpl = (MethodImplementation)impl;
                for (CloudImageDescription cid_gci : cp.getCompatibleImages(mImpl.getRequirements())) {
                    System.out.println("\t\t\t Checking compatible Image: " + cid_gci.getImageName());
                    res = Test.checkImplementationAssignedToCloudImage(mImpl.getRequirements(), cid_gci);
                    if (res == null) continue;
                    error = "[ERROR] Implementation: Core = " + coreId + " Impl = " + impl.getImplementationId() + ". ";
                    error = error.concat("Implementation and cloud image not matching on: " + res);
                    System.out.println(error);
                    System.exit(-1);
                }
                System.out.println("\t\t Checking obtained compatible cloud types");
                for (CloudInstanceTypeDescription type : cp.getCompatibleTypes((MethodResourceDescription)new CloudMethodResourceDescription(mImpl.getRequirements()))) {
                    if (type.getResourceDescription().canHostSimultaneously(mImpl.getRequirements()) < 1) continue;
                    System.out.println("\t\t\t Checking compatible Type: " + type.getName());
                    res = Test.checkImplementationAssignedToType(mImpl.getRequirements(), type.getResourceDescription());
                    if (res == null) continue;
                    error = "[ERROR] Implementation: Core = " + coreId + " Impl = " + impl.getImplementationId() + ". ";
                    error = error.concat("Implementation and type not matching on: " + res);
                    System.out.println(error);
                    System.exit(-1);
                }
            }
        }
        System.out.println("[LOG] * CloudManager test passed");
    }

    private static String checkImplementationAssignedToCloudImage(MethodResourceDescription rd, CloudImageDescription cid) {
        if (!(cid.getOperatingSystemType().equals("[unassigned]") || rd.getOperatingSystemType().equals("[unassigned]") || cid.getOperatingSystemType().equals(rd.getOperatingSystemType()))) {
            return "operatingSystemType";
        }
        if (!(cid.getOperatingSystemDistribution().equals("[unassigned]") || rd.getOperatingSystemDistribution().equals("[unassigned]") || cid.getOperatingSystemDistribution().equals(rd.getOperatingSystemDistribution()))) {
            return "operatingSystemDistribution";
        }
        if (!(cid.getOperatingSystemVersion().equals("[unassigned]") || rd.getOperatingSystemVersion().equals("[unassigned]") || cid.getOperatingSystemVersion().equals(rd.getOperatingSystemVersion()))) {
            return "operatingSystemVersion";
        }
        if (!(cid.getAppSoftware().isEmpty() || rd.getAppSoftware().isEmpty() || cid.getAppSoftware().containsAll(rd.getAppSoftware()))) {
            return "softwareApps";
        }
        return null;
    }

    private static String checkImplementationAssignedToType(MethodResourceDescription rdImpl, MethodResourceDescription rdType) {
        if (rdImpl.getTotalCPUComputingUnits() >= 1 && rdType.getTotalCPUComputingUnits() >= 1 && rdType.getTotalCPUComputingUnits() < rdImpl.getTotalCPUComputingUnits()) {
            return "computingUnits";
        }
        for (Processor ip : rdImpl.getProcessors()) {
            boolean canBeHosted = false;
            for (Processor wp : rdType.getProcessors()) {
                if (!ip.getName().equals("[unassigned]") && !wp.getName().equals("[unassigned]") && !wp.getName().equals(ip.getName()) || ip.getSpeed() != -1.0f && wp.getSpeed() != -1.0f && wp.getSpeed() < ip.getSpeed() || !ip.getArchitecture().equals("[unassigned]") && !wp.getArchitecture().equals("[unassigned]") && !wp.getArchitecture().equals(ip.getArchitecture()) || !ip.getPropName().equals("[unassigned]") && !wp.getPropName().equals("[unassigned]") && !ip.getPropName().equals(wp.getPropName()) || !ip.getPropValue().equals("[unassigned]") && !wp.getPropValue().equals("[unassigned]") && !ip.getPropValue().equals(wp.getPropValue()) || wp.getComputingUnits() < ip.getComputingUnits()) continue;
                canBeHosted = true;
                break;
            }
            if (canBeHosted) continue;
            return "processor";
        }
        if (rdImpl.getMemorySize() != -1.0f && rdType.getMemorySize() != -1.0f && rdType.getMemorySize() < rdImpl.getMemorySize()) {
            return "memorySize";
        }
        if (!(rdImpl.getMemoryType().equals("[unassigned]") || rdImpl.getMemoryType().equals("[unassigned]") || rdType.getMemoryType().equals(rdImpl.getMemoryType()))) {
            return "memoryType";
        }
        if (rdImpl.getStorageSize() != -1.0f && rdType.getStorageSize() != -1.0f && rdType.getStorageSize() < rdImpl.getStorageSize()) {
            return "storageSize";
        }
        if (!(rdImpl.getStorageType().equals("[unassigned]") || rdImpl.getStorageType().equals("[unassigned]") || rdType.getStorageType().equals(rdImpl.getStorageType()))) {
            return "storageType";
        }
        if (!(rdImpl.getOperatingSystemType().equals("[unassigned]") || rdType.getOperatingSystemType().equals("[unassigned]") || rdType.getOperatingSystemType().equals(rdImpl.getOperatingSystemType()))) {
            return "operatingSystemType";
        }
        if (!(rdImpl.getOperatingSystemDistribution().equals("[unassigned]") || rdType.getOperatingSystemDistribution().equals("[unassigned]") || rdType.getOperatingSystemDistribution().equals(rdImpl.getOperatingSystemDistribution()))) {
            return "operatingSystemDistribution";
        }
        if (!(rdImpl.getOperatingSystemVersion().equals("[unassigned]") || rdType.getOperatingSystemVersion().equals("[unassigned]") || rdType.getOperatingSystemVersion().equals(rdImpl.getOperatingSystemVersion()))) {
            return "operatingSystemVersion";
        }
        if (!rdImpl.getAppSoftware().isEmpty() && !rdType.getAppSoftware().containsAll(rdImpl.getAppSoftware())) {
            return "appSoftware";
        }
        if (!rdImpl.getHostQueues().isEmpty() && !rdType.getHostQueues().containsAll(rdImpl.getHostQueues())) {
            return "hostQueues";
        }
        return null;
    }
}

