/*
 * Decompiled with CFR 0.152.
 */
package constraintManager;

import constraintManager.TestItf;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.annotations.Constraints;
import es.bsc.compss.types.annotations.task.Method;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.components.Processor;
import es.bsc.compss.util.CoreManager;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Test {
    private static final int WAIT_FOR_RUNTIME_TIME = 10000;
    private static int coreCountItf;
    private static String[][] declaringClassesItf;
    private static Constraints[][] constraintsItf;
    private static Constraints[] generalConstraintsItf;
    private static String[] coreToName;
    private static Map<String, Integer> signatureToId;
    private static LinkedList<String>[] idToSignatures;

    public static void main(String[] args) {
        System.out.println("[LOG] Waiting for Runtime to be loaded");
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[LOG] Running ConstraintManager Test");
        Test.constraintManagerTest();
    }

    private static void constraintManagerTest() {
        int i;
        java.lang.reflect.Method[] declaredMethodsItf = TestItf.class.getDeclaredMethods();
        coreCountItf = declaredMethodsItf.length;
        if (CoreManager.getCoreCount() != coreCountItf) {
            System.out.println("[ERROR]" + CoreManager.getCoreCount() + " CE registered in the runtime and  " + coreCountItf + " declared in the CEI");
            System.exit(-1);
        }
        signatureToId = CoreManager.getSignaturesToCoreIds();
        idToSignatures = new LinkedList[coreCountItf];
        for (int coreId = 0; coreId < coreCountItf; ++coreId) {
            Test.idToSignatures[coreId] = new LinkedList();
        }
        for (Map.Entry<String, Integer> entry : signatureToId.entrySet()) {
            String signature = entry.getKey();
            Integer coreId = entry.getValue();
            idToSignatures[coreId].add(signature);
        }
        declaringClassesItf = new String[coreCountItf][];
        constraintsItf = new Constraints[coreCountItf][];
        generalConstraintsItf = new Constraints[coreCountItf];
        coreToName = new String[coreCountItf];
        for (i = 0; i < coreCountItf; ++i) {
            Method methodAnnotation;
            int j;
            int cutValue1 = idToSignatures[i].getFirst().indexOf("(");
            int cutValue2 = idToSignatures[i].getFirst().indexOf(")");
            Test.coreToName[i] = idToSignatures[i].getFirst().substring(0, cutValue1);
            String params = idToSignatures[i].getFirst().substring(cutValue1, cutValue2);
            java.lang.reflect.Method m = null;
            try {
                m = params.equals("(") ? TestItf.class.getDeclaredMethod(coreToName[i], new Class[0]) : TestItf.class.getDeclaredMethod(coreToName[i], String.class);
            }
            catch (NoSuchMethodException nsme) {
                System.out.println("[ERROR] Method " + coreToName[i] + "not found.");
                System.exit(-1);
            }
            if (m.isAnnotationPresent(Constraints.class)) {
                Test.generalConstraintsItf[i] = m.getAnnotation(Constraints.class);
            }
            Method[] annotations = (Method[])m.getAnnotationsByType(Method.class);
            Test.declaringClassesItf[i] = new String[annotations.length];
            for (j = 0; j < annotations.length; ++j) {
                methodAnnotation = annotations[j];
                Test.declaringClassesItf[i][j] = methodAnnotation.declaringClass();
            }
            Test.constraintsItf[i] = new Constraints[annotations.length];
            for (j = 0; j < annotations.length; ++j) {
                methodAnnotation = annotations[j];
                Test.constraintsItf[i][j] = methodAnnotation.constraints();
            }
        }
        for (i = 0; i < coreCountItf; ++i) {
            if (declaringClassesItf[i] == null) continue;
            Test.checkCoreElementConstraints(i);
        }
    }

    private static void checkCoreElementConstraints(int coreId) {
        CoreElement ce = CoreManager.getCore((int)coreId);
        System.out.println("[LOG] Checking " + coreToName[coreId]);
        System.out.println("[LOG] \t Has " + declaringClassesItf[coreId].length + " declaring classes in the CEI");
        System.out.println("[LOG] \t Has " + idToSignatures[coreId].size() + " signatures registered");
        if (declaringClassesItf[coreId].length + 1 != idToSignatures[coreId].size()) {
            System.out.println(coreToName[coreId] + " has " + idToSignatures[coreId].size() + " registered signatures and there are " + declaringClassesItf[coreId].length + " declaringClasses in the CEI");
            System.exit(-1);
        }
        List implementations = ce.getImplementations();
        System.out.println("[LOG] \t Has " + implementations.size() + " implementations registered");
        if (declaringClassesItf[coreId].length != implementations.size()) {
            System.out.println(coreToName[coreId] + " has " + implementations.size() + " registered implementations and there are " + declaringClassesItf[coreId].length + " declaringClasses in the CEI");
            System.exit(-1);
        }
        for (int implId = 0; implId < declaringClassesItf[coreId].length; ++implId) {
            String constraint;
            MethodImplementation m = (MethodImplementation)implementations.get(implId);
            System.out.println("[LOG] \t" + declaringClassesItf[coreId][implId]);
            if (declaringClassesItf[coreId][implId].compareTo(m.getDeclaringClass()) != 0) {
                System.out.println(coreToName[coreId] + "'s declaringClass " + declaringClassesItf[coreId][implId] + " is not included registered in the system");
                System.exit(-1);
            }
            if ((constraint = Test.checkConstraints(generalConstraintsItf[coreId], constraintsItf[coreId][implId], m.getRequirements())) == null) continue;
            System.out.println("Constraints for " + coreToName[coreId] + "'s declaringClass " + declaringClassesItf[coreId][implId] + " does not meet the annotations (" + constraint + ")");
            System.exit(-1);
        }
    }

    private static String checkConstraints(Constraints general, Constraints specific, MethodResourceDescription registered) {
        HashSet<String> values;
        boolean ret = true;
        if (general == null || general.computingUnits().equals("[unassigned]")) {
            ret = specific == null || specific.computingUnits().equals("[unassigned]") ? registered.getTotalCPUComputingUnits() == 1 : registered.getTotalCPUComputingUnits() == Integer.valueOf(specific.computingUnits()).intValue();
        } else if (specific == null || specific.computingUnits().equals("[unassigned]")) {
            ret = registered.getTotalCPUComputingUnits() == Integer.valueOf(general.computingUnits()).intValue();
        } else {
            boolean bl = ret = registered.getTotalCPUComputingUnits() == Integer.valueOf(specific.computingUnits()).intValue();
        }
        if (!ret) {
            if (general != null) {
                System.out.println("GEN: " + general.computingUnits());
            }
            if (specific != null) {
                System.out.println("SPC: " + specific.computingUnits());
            }
            System.out.println("REG: " + registered.getTotalCPUComputingUnits());
            return "computingUnits";
        }
        ret = general == null || general.processorName().equals("[unassigned]") ? (specific == null || specific.processorName().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getName().equals("[unassigned]") : ((Processor)registered.getProcessors().get(0)).getName().equals(specific.processorName())) : (specific == null || specific.processorName().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getName().equals(general.processorName()) : ((Processor)registered.getProcessors().get(0)).getName().equals(specific.processorName()));
        if (!ret) {
            return "processorName";
        }
        if (general == null || general.processorSpeed().equals("[unassigned]")) {
            ret = specific == null || specific.processorSpeed().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getSpeed() == -1.0f : ((Processor)registered.getProcessors().get(0)).getSpeed() == Float.valueOf(specific.processorSpeed()).floatValue();
        } else if (specific == null || specific.processorSpeed().equals("[unassigned]")) {
            ret = ((Processor)registered.getProcessors().get(0)).getSpeed() == Float.valueOf(general.processorSpeed()).floatValue();
        } else {
            boolean bl = ret = ((Processor)registered.getProcessors().get(0)).getSpeed() == Float.valueOf(specific.processorSpeed()).floatValue();
        }
        if (!ret) {
            return "processorSpeed";
        }
        ret = general == null || general.processorArchitecture().equals("[unassigned]") ? (specific == null || specific.processorArchitecture().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getArchitecture().equals("[unassigned]") : ((Processor)registered.getProcessors().get(0)).getArchitecture().equals(specific.processorArchitecture())) : (specific == null || specific.processorArchitecture().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getArchitecture().equals(general.processorArchitecture()) : ((Processor)registered.getProcessors().get(0)).getArchitecture().equals(specific.processorArchitecture()));
        if (!ret) {
            return "processorArchitecture";
        }
        ret = general == null || general.processorPropertyName().equals("[unassigned]") ? (specific == null || specific.processorPropertyName().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getPropName().equals("[unassigned]") : ((Processor)registered.getProcessors().get(0)).getPropName().equals(specific.processorPropertyName())) : (specific == null || specific.processorPropertyName().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getPropName().equals(general.processorPropertyName()) : ((Processor)registered.getProcessors().get(0)).getPropName().equals(specific.processorPropertyName()));
        if (!ret) {
            return "processorPropertyName";
        }
        ret = general == null || general.processorPropertyValue().equals("[unassigned]") ? (specific == null || specific.processorPropertyValue().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getPropValue().equals("[unassigned]") : ((Processor)registered.getProcessors().get(0)).getPropValue().equals(specific.processorPropertyValue())) : (specific == null || specific.processorPropertyValue().equals("[unassigned]") ? ((Processor)registered.getProcessors().get(0)).getPropValue().equals(general.processorPropertyValue()) : ((Processor)registered.getProcessors().get(0)).getPropValue().equals(specific.processorPropertyValue()));
        if (!ret) {
            return "processorPropertyValue";
        }
        if (general == null || general.memorySize().equals("[unassigned]")) {
            ret = specific == null || specific.memorySize().equals("[unassigned]") ? registered.getMemorySize() == -1.0f : registered.getMemorySize() == Float.valueOf(specific.memorySize()).floatValue();
        } else if (specific == null || specific.memorySize().equals("[unassigned]")) {
            ret = registered.getMemorySize() == Float.valueOf(general.memorySize()).floatValue();
        } else {
            boolean bl = ret = registered.getMemorySize() == Float.valueOf(specific.memorySize()).floatValue();
        }
        if (!ret) {
            return "memorySize";
        }
        ret = general == null || general.memoryType().equals("[unassigned]") ? (specific == null || specific.memoryType().equals("[unassigned]") ? registered.getMemoryType().equals("[unassigned]") : registered.getMemoryType().equals(specific.memoryType())) : (specific == null || specific.memoryType().equals("[unassigned]") ? registered.getMemoryType().equals(general.memoryType()) : registered.getMemoryType().equals(specific.memoryType()));
        if (!ret) {
            return "memoryType";
        }
        if (general == null || general.storageSize().equals("[unassigned]")) {
            ret = specific == null || specific.storageSize().equals("[unassigned]") ? registered.getStorageSize() == -1.0f : registered.getStorageSize() == Float.valueOf(specific.storageSize()).floatValue();
        } else if (specific == null || specific.storageSize().equals("[unassigned]")) {
            ret = registered.getStorageSize() == Float.valueOf(general.storageSize()).floatValue();
        } else {
            boolean bl = ret = registered.getStorageSize() == Float.valueOf(specific.storageSize()).floatValue();
        }
        if (!ret) {
            return "storageSize";
        }
        ret = general == null || general.storageType().equals("[unassigned]") ? (specific == null || specific.storageType().equals("[unassigned]") ? registered.getStorageType().equals("[unassigned]") : registered.getStorageType().equals(specific.storageType())) : (specific == null || specific.storageType().equals("[unassigned]") ? registered.getStorageType().equals(general.storageType()) : registered.getStorageType().equals(specific.storageType()));
        if (!ret) {
            return "storageType";
        }
        if (general == null || general.storageBW().equals("[unassigned]")) {
            ret = specific == null || specific.storageBW().equals("[unassigned]") ? registered.getStorageBW() == -1 : registered.getStorageBW() == Integer.valueOf(specific.storageBW()).intValue();
        } else if (specific == null || specific.storageBW().equals("[unassigned]")) {
            ret = registered.getStorageBW() == Integer.valueOf(general.storageBW()).intValue();
        } else {
            boolean bl = ret = registered.getStorageBW() == Integer.valueOf(specific.storageBW()).intValue();
        }
        if (!ret) {
            return "storageBW";
        }
        ret = general == null || general.operatingSystemType().equals("[unassigned]") ? (specific == null || specific.operatingSystemType().equals("[unassigned]") ? registered.getOperatingSystemType().equals("[unassigned]") : registered.getOperatingSystemType().equals(specific.operatingSystemType())) : (specific == null || specific.operatingSystemType().equals("[unassigned]") ? registered.getOperatingSystemType().equals(general.operatingSystemType()) : registered.getOperatingSystemType().equals(specific.operatingSystemType()));
        if (!ret) {
            return "operatingSystemType";
        }
        ret = general == null || general.operatingSystemDistribution().equals("[unassigned]") ? (specific == null || specific.operatingSystemDistribution().equals("[unassigned]") ? registered.getOperatingSystemDistribution().equals("[unassigned]") : registered.getOperatingSystemDistribution().equals(specific.operatingSystemDistribution())) : (specific == null || specific.operatingSystemDistribution().equals("[unassigned]") ? registered.getOperatingSystemDistribution().equals(general.operatingSystemDistribution()) : registered.getOperatingSystemDistribution().equals(specific.operatingSystemDistribution()));
        if (!ret) {
            return "operatingSystemDistribution";
        }
        ret = general == null || general.operatingSystemVersion().equals("[unassigned]") ? (specific == null || specific.operatingSystemVersion().equals("[unassigned]") ? registered.getOperatingSystemVersion().equals("[unassigned]") : registered.getOperatingSystemVersion().equals(specific.operatingSystemVersion())) : (specific == null || specific.operatingSystemVersion().equals("[unassigned]") ? registered.getOperatingSystemVersion().equals(general.operatingSystemVersion()) : registered.getOperatingSystemVersion().equals(specific.operatingSystemVersion()));
        if (!ret) {
            return "operatingSystemVersion";
        }
        if (general == null || general.appSoftware().equals("[unassigned]")) {
            if (specific == null || specific.appSoftware().equals("[unassigned]")) {
                ret = registered.getAppSoftware().isEmpty();
            } else {
                values = new HashSet();
                for (String s : specific.appSoftware().split(",")) {
                    if (s.compareTo(",") == 0) continue;
                    values.add(s.replaceAll(" ", ""));
                }
                ret = registered.getAppSoftware().containsAll(values);
            }
        } else if (specific == null || specific.appSoftware().equals("[unassigned]")) {
            values = new HashSet<String>();
            for (String s : general.appSoftware().split(",")) {
                if (s.compareTo(",") == 0) continue;
                values.add(s.replaceAll(" ", ""));
            }
            ret = registered.getAppSoftware().containsAll(values);
        } else {
            values = new HashSet();
            for (String s : general.appSoftware().split(",")) {
                if (s.compareTo(",") == 0) continue;
                values.add(s.replaceAll(" ", ""));
            }
            for (String s : specific.appSoftware().split(",")) {
                if (s.compareTo(",") == 0) continue;
                values.add(s.replaceAll(" ", ""));
            }
            ret = registered.getAppSoftware().containsAll(values);
        }
        if (!ret) {
            return "applicationSoftware";
        }
        if (general == null || general.hostQueues().equals("[unassigned]")) {
            if (specific == null || specific.hostQueues().equals("[unassigned]")) {
                ret = registered.getHostQueues().isEmpty();
            } else {
                values = new HashSet();
                for (String s : specific.hostQueues().split(",")) {
                    if (s.compareTo(",") == 0) continue;
                    values.add(s.replaceAll(" ", "").toUpperCase());
                }
                ret = registered.getHostQueues().containsAll(values);
            }
        } else if (specific == null || specific.hostQueues().equals("[unassigned]")) {
            values = new HashSet();
            for (String s : general.hostQueues().split(",")) {
                if (s.compareTo(",") == 0) continue;
                values.add(s.replaceAll(" ", "").toUpperCase());
            }
            ret = registered.getHostQueues().containsAll(values);
        } else {
            values = new HashSet();
            for (String s : general.hostQueues().split(",")) {
                if (s.compareTo(",") == 0) continue;
                values.add(s.replaceAll(" ", "").toUpperCase());
            }
            for (String s : specific.hostQueues().split(",")) {
                if (s.compareTo(",") == 0) continue;
                values.add(s.replaceAll(" ", "").toUpperCase());
            }
            ret = registered.getHostQueues().containsAll(values);
        }
        if (!ret) {
            return "hostQueues";
        }
        if (general == null || general.wallClockLimit().equals("[unassigned]")) {
            ret = specific == null || specific.wallClockLimit().equals("[unassigned]") ? registered.getWallClockLimit() == -1 : registered.getWallClockLimit() == Integer.valueOf(specific.wallClockLimit()).intValue();
        } else if (specific == null || specific.wallClockLimit().equals("[unassigned]")) {
            ret = registered.getWallClockLimit() == Integer.valueOf(general.wallClockLimit()).intValue();
        } else {
            boolean bl = ret = registered.getWallClockLimit() == Integer.valueOf(specific.wallClockLimit()).intValue();
        }
        if (!ret) {
            return "wallClockLimit";
        }
        return null;
    }
}

