/*
 * Decompiled with CFR 0.152.
 */
package kmeans;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class KMeansDataSet {
    private static final int cookie = 732822976;
    private static final int version = 1;
    public final int numPoints;
    public final int numDimensions;
    public final float[][] points;
    public final float[] currentCluster;

    public KMeansDataSet(int np, int nd, float[][] pts, float[] cluster) {
        assert (np * nd == pts.length);
        this.numPoints = np;
        this.numDimensions = nd;
        this.points = pts;
        this.currentCluster = cluster;
    }

    public final int getPointOffset(int point) {
        return point * this.numDimensions;
    }

    public static KMeansDataSet generateRandomPoints(int numPoints, int numDimensions, int numFrags, int K) {
        float[][] points = new float[numFrags][];
        float[] cluster = new float[K * numDimensions];
        return new KMeansDataSet(numPoints, numDimensions, points, cluster);
    }

    public static boolean generateRandomPointsToFile(String fileName, int numPoints, int numDimensions, int seed) {
        try {
            Random rand = new Random(seed);
            File outputFile = new File(fileName);
            DataOutputStream out = new DataOutputStream(new FileOutputStream(outputFile));
            out.writeInt(732822976);
            out.writeInt(1);
            out.writeInt(numPoints);
            out.writeInt(numDimensions);
            int numFloats = numPoints * numDimensions;
            for (int i = 0; i < numFloats; ++i) {
                out.writeFloat(rand.nextFloat());
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to open file for writing " + fileName);
            return false;
        }
        catch (IOException e) {
            System.out.println("Error writing data to " + fileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

