/*
 * Decompiled with CFR 0.152.
 */
package kmeans;

import java.lang.reflect.Array;
import java.util.Random;
import kmeans.KMeansDataSet;

public class KMeans {
    public static void computeNewLocalClusters(int myK, int numDimensions, float[] points, float[] clusterPoints, float[] newClusterPoints, int[] clusterCounts) {
        int numPoints = points.length / numDimensions;
        for (int pointNumber = 0; pointNumber < numPoints; ++pointNumber) {
            int closest = -1;
            float closestDist = Float.MAX_VALUE;
            for (int k = 0; k < myK; ++k) {
                float dist = 0.0f;
                for (int dim = 0; dim < numDimensions; ++dim) {
                    float tmp = points[pointNumber * numDimensions + dim] - clusterPoints[k * numDimensions + dim];
                    dist += tmp * tmp;
                }
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest = k;
            }
            for (int dim = 0; dim < numDimensions; ++dim) {
                int n = closest * numDimensions + dim;
                newClusterPoints[n] = newClusterPoints[n] + points[pointNumber * numDimensions + dim];
            }
            int n = closest;
            clusterCounts[n] = clusterCounts[n] + 1;
        }
    }

    public static void accumulate(float[] onePoints, float[] otherPoints, int[] oneCounts, int[] otherCounts) {
        int i;
        for (i = 0; i < otherPoints.length; ++i) {
            int n = i;
            onePoints[n] = onePoints[n] + otherPoints[i];
        }
        for (i = 0; i < otherCounts.length; ++i) {
            int n = i;
            oneCounts[n] = oneCounts[n] + otherCounts[i];
        }
    }

    public static float[] initPointsFrag(int size, int seed) {
        float[] points = new float[size];
        Random rnd = new Random(seed);
        for (int j = 0; j < size; ++j) {
            points[j] = rnd.nextFloat();
        }
        return points;
    }

    private static void localReduction(float[] points, int[] counts, int K, int numDimensions, float[] cluster) {
        for (int k = 0; k < K; ++k) {
            float tmp = counts[k];
            for (int dim = 0; dim < numDimensions; ++dim) {
                int n = k * numDimensions + dim;
                points[n] = points[n] / tmp;
            }
        }
        System.arraycopy(points, 0, cluster, 0, cluster.length);
    }

    private static void initializePoints(KMeansDataSet data, int numFrags) {
        int pointsPerFragment = data.numPoints / numFrags;
        for (int i = 0; i < numFrags; ++i) {
            int start = i * pointsPerFragment;
            int stop = Math.min(start + pointsPerFragment - 1, data.numPoints * data.numDimensions);
            int numPointsFrag = stop - start + 1;
            data.points[i] = KMeans.initPointsFrag(numPointsFrag * data.numDimensions, i);
        }
        int nFrag = 0;
        int startPos = 0;
        int toCopy = data.currentCluster.length;
        while (toCopy > 0) {
            int copied = KMeans.copyToCluster(data.points[nFrag], data.currentCluster, toCopy, startPos);
            toCopy -= copied;
            startPos += copied;
            ++nFrag;
        }
    }

    private static int copyToCluster(float[] points, float[] cluster, int toCopy, int startPos) {
        int canCopy = Math.min(toCopy, Array.getLength(points));
        int j = 0;
        for (int i = startPos; i < startPos + canCopy; ++i) {
            cluster[i] = points[j++];
        }
        return j;
    }

    private static void printPoints(float[] points) {
        System.out.println("No print");
        System.out.println("");
    }

    public static void main(String[] args) {
        int K = 4;
        int iterations = 20;
        int nPoints = 2000;
        int nDimensions = 2;
        int nFrags = 2;
        System.out.println("Running with the following parameters:");
        System.out.println("- Iterations: " + iterations);
        System.out.println("- Points: " + nPoints);
        System.out.println("- Dimensions: " + nDimensions);
        System.out.println("- Nodes: " + nFrags);
        System.out.println("- Clusters: " + K);
        KMeansDataSet data = KMeansDataSet.generateRandomPoints(nPoints, nDimensions, nFrags, K);
        int[][] clusterCounts = new int[nFrags][K];
        float[][] newClusters = new float[nFrags][K * data.numDimensions];
        KMeans.initializePoints(data, nFrags);
        for (int iter = 0; iter < iterations; ++iter) {
            for (int i = 0; i < nFrags; ++i) {
                float[] frag = data.points[i];
                KMeans.computeNewLocalClusters(K, nDimensions, frag, data.currentCluster, newClusters[i], clusterCounts[i]);
            }
            int i = 0;
            int gap = 1;
            for (int size = newClusters.length; size > 1; --size) {
                KMeans.accumulate(newClusters[i], newClusters[i + gap], clusterCounts[i], clusterCounts[i + gap]);
                if ((i += 2 * gap) != newClusters.length) continue;
                gap *= 2;
                i = 0;
            }
            KMeans.localReduction(newClusters[0], clusterCounts[0], K, data.numDimensions, data.currentCluster);
        }
        System.out.println("Result clusters: ");
        for (int k = 0; k < K; ++k) {
            for (int j = 0; j < data.numDimensions; ++j) {
                if (j > 0) {
                    System.out.print(" ");
                }
                System.out.print(data.currentCluster[k * data.numDimensions + j]);
            }
            System.out.println();
        }
        System.out.println();
    }
}

