/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.io.Serializable;
import java.util.LinkedList;
import model.Computer;
import storage.StorageObject;

public class Person
extends StorageObject
implements Serializable {
    private static final long serialVersionUID = 3L;
    private String name;
    private int age;
    private final LinkedList<Computer> computers = new LinkedList();

    public Person() {
    }

    public Person(String name, int age, int numC) {
        this.name = name;
        this.age = age;
        for (int i = 0; i < numC; ++i) {
            String compId = name + "_" + String.valueOf(i);
            Computer c = new Computer("DELL", "Latitude", compId, age);
            this.computers.add(c);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getAge() {
        return this.age;
    }

    public LinkedList<Computer> getComputers() {
        return this.computers;
    }

    public int getNumComputers() {
        return this.computers.size();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void addComputer(Computer c) {
        this.computers.add(c);
    }

    public void taskPSCOTarget() {
        System.out.println("[LOG] Person " + this.name + " with age " + this.age + " has " + this.computers.size() + " computers");
        this.setName("Another");
        this.setAge(10);
        Computer c = new Computer("DELL", "Latitude", this.name + "_" + this.age, this.age);
        this.addComputer(c);
        System.out.println("[LOG] Person " + this.name + " with age " + this.age + " has " + this.computers.size() + " computers");
        String pId = this.getID();
        this.deletePersistent();
        this.makePersistent(pId);
    }

    public void taskPSCOTargetTaskPersisted(String id) {
        System.out.println("[LOG] Person " + this.name + " with age " + this.age + " has " + this.computers.size() + " computers");
        this.setName("Another");
        this.setAge(10);
        Computer c = new Computer("DELL", "Latitude", this.name + "_" + this.age, this.age);
        this.addComputer(c);
        System.out.println("[LOG] Person " + this.name + " with age " + this.age + " has " + this.computers.size() + " computers");
        String pId = this.getID();
        this.deletePersistent();
        this.makePersistent(pId);
    }

    public void taskPSCOTargetWithParams(String newName, Person p) {
        System.out.println("[LOG] Person " + this.name + " with age " + this.age + " has " + this.computers.size() + " computers");
        this.setName(newName);
        this.setAge(10);
        Computer c = new Computer("DELL", "Latitude", this.name + "_" + this.age, this.age);
        this.addComputer(c);
        for (Computer computer : p.getComputers()) {
            this.addComputer(computer);
        }
        System.out.println("[LOG] Person " + this.name + " with age " + this.age + " has " + this.computers.size() + " computers");
        String pId = this.getID();
        this.deletePersistent();
        this.makePersistent(pId);
    }

    public void taskMap(String newName) {
        this.setName(newName);
        String pId = this.getID();
        this.deletePersistent();
        this.makePersistent(pId);
    }

    public void taskReduce(Person p2) {
        this.setName(this.getName() + "," + p2.getName());
        this.setAge(this.getAge() + p2.getAge());
        for (Computer c : p2.getComputers()) {
            this.addComputer(c);
        }
        String pId = this.getID();
        this.deletePersistent();
        this.makePersistent(pId);
    }
}

