/*
 * Decompiled with CFR 0.152.
 */
package testPSCOInternal;

import java.util.LinkedList;
import java.util.UUID;
import model.Person;
import testPSCOInternal.InternalImpl;

public class Internal {
    public static void main(String[] args) {
        System.out.println("[LOG] Test PSCO IN");
        Internal.testPSCOIn();
        System.out.println("[LOG] Test PSCO INOUT");
        Internal.testPSCOInOut();
        System.out.println("[LOG] Test PSCO RETURN");
        Internal.testPSCOReturn();
        System.out.println("[LOG] Test PSCO TARGET");
        Internal.testPSCOTarget();
        System.out.println("[LOG] Test PSCO INOUT TASK PERSISTED");
        Internal.testPSCOInOutTaskPersisted();
        System.out.println("[LOG] Test PSCO IN RETURN NO TASK PERSISTED");
        Internal.testPSCOReturnNoTaskPersisted();
        System.out.println("[LOG] Test PSCO TARGET TASK PERSISTED");
        Internal.testPSCOTargetTaskPersisted();
        System.out.println("[LOG] Test PSCO MERGE-REDUCE");
        Internal.testMergeReduce();
        System.out.println("[LOG] Test PSCO MERGE-REDUCE WITH TARGET");
        Internal.testMergeReduceTarget();
    }

    private static void testPSCOIn() {
        String id = "person_" + UUID.randomUUID().toString();
        Person p = new Person("PName1", 1, 1);
        p.makePersistent(id);
        InternalImpl.taskPSCOIn(p);
    }

    private static void testPSCOInOut() {
        String id = "person_" + UUID.randomUUID().toString();
        Person p = new Person("PName2", 2, 2);
        p.makePersistent(id);
        InternalImpl.taskPSCOInOut(p);
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_INOUT] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_INOUT] BeginId = " + id + " EndId = " + p.getID());
    }

    private static void testPSCOInOutTaskPersisted() {
        Person p = new Person("PName2", 2, 2);
        String id = InternalImpl.taskPSCOInOutTaskPersisted(p);
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_INOUT_TP] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_INOUT_TP] BeginId = " + id + " EndId = " + p.getID());
    }

    private static void testPSCOReturn() {
        String id = "person_" + UUID.randomUUID().toString();
        Person p = InternalImpl.taskPSCOReturn("PName3", 3, 3, id);
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_RETURN] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_RETURN] BeginId = " + id + " EndId = " + p.getID());
    }

    private static void testPSCOReturnNoTaskPersisted() {
        Person p = InternalImpl.taskPSCOReturnNoTaskPersisted("PName3", 3, 3);
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_RETURN_NTP] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_RETURN_NTP] BeginId = null EndId = " + p.getID());
    }

    private static void testPSCOTarget() {
        String id = "person_" + UUID.randomUUID().toString();
        Person p = new Person("PName1", 1, 1);
        p.makePersistent(id);
        p.taskPSCOTarget();
        p.taskPSCOTarget();
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_TARGET] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_TARGET] BeginId = " + id + " EndId = " + p.getID());
    }

    private static void testPSCOTargetTaskPersisted() {
        String id = "person_" + UUID.randomUUID().toString();
        Person p = new Person("PName1", 1, 1);
        p.taskPSCOTargetTaskPersisted(id);
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_TARGET_TP] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_TARGET_TP] BeginId = null EndId = " + p.getID());
    }

    public static void testMergeReduce() {
        int i;
        Person[] people = new Person[4];
        for (i = 0; i < people.length; ++i) {
            String id = "person_" + UUID.randomUUID().toString();
            System.out.println("[LOG][PSCO_MR] Person " + i + " BeginId = " + id);
            people[i] = new Person("PName" + i, i, i);
            people[i].makePersistent(id);
        }
        for (i = 0; i < people.length; ++i) {
            people[i] = InternalImpl.taskMap("NewName" + i, people[i]);
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (int i2 = 0; i2 < people.length; ++i2) {
            q.add(i2);
        }
        int x = 0;
        while (!q.isEmpty()) {
            x = (Integer)q.poll();
            if (q.isEmpty()) continue;
            int y = (Integer)q.poll();
            people[x] = InternalImpl.taskReduce(people[x], people[y]);
            q.add(x);
        }
        Person p1 = people[0];
        String name = p1.getName();
        int age = p1.getAge();
        int numC = p1.getNumComputers();
        System.out.println("[LOG][PSCO_MR] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_MR] EndId = " + p1.getID());
    }

    public static void testMergeReduceTarget() {
        int i;
        Person[] people = new Person[4];
        for (i = 0; i < people.length; ++i) {
            String id = "person_" + UUID.randomUUID().toString();
            System.out.println("[LOG][PSCO_MR_TARGET] Person " + i + " BeginId = " + id);
            people[i] = new Person("PName" + i, i, i);
            people[i].makePersistent(id);
        }
        for (i = 0; i < people.length; ++i) {
            people[i].taskMap("NewName" + i);
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (int i2 = 0; i2 < people.length; ++i2) {
            q.add(i2);
        }
        int x = 0;
        while (!q.isEmpty()) {
            x = (Integer)q.poll();
            if (q.isEmpty()) continue;
            int y = (Integer)q.poll();
            people[x].taskReduce(people[y]);
            q.add(x);
        }
        Person p1 = people[0];
        String name = p1.getName();
        int age = p1.getAge();
        int numC = p1.getNumComputers();
        System.out.println("[LOG][PSCO_MR_TARGET] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_MR_TARGET] EndId = " + p1.getID());
    }
}

