/*
 * Decompiled with CFR 0.152.
 */
package testPSCOExternal;

import java.util.LinkedList;
import java.util.UUID;
import model.Person;

public class External {
    public static void main(String[] args) {
        System.out.println("[LOG] Test PSCO TARGET");
        External.testPSCOTarget();
        System.out.println("[LOG] Test PSCO MERGE-REDUCE WITH TARGET");
    }

    private static void testPSCOTarget() {
        String id = "person_" + UUID.randomUUID().toString();
        Person p = new Person("PName1", 1, 1);
        p.makePersistent(id);
        String id2 = "person_" + UUID.randomUUID().toString();
        Person p2 = new Person("PName2", 1, 2);
        p2.makePersistent(id2);
        p.taskPSCOTargetWithParams("Another", p2);
        String name = p.getName();
        int age = p.getAge();
        int numC = p.getNumComputers();
        System.out.println("[LOG][PSCO_TARGET] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_TARGET] BeginId = " + id + " EndId = " + p.getID());
    }

    public static void testMergeReduceTarget() {
        int i;
        Person[] people = new Person[4];
        for (i = 0; i < people.length; ++i) {
            String id = "person_" + UUID.randomUUID().toString();
            System.out.println("[LOG][PSCO_MR_TARGET] Person " + i + " BeginId = " + id);
            people[i] = new Person("PName" + i, i, i);
            people[i].makePersistent(id);
        }
        for (i = 0; i < people.length; ++i) {
            people[i].taskMap("NewName" + i);
        }
        LinkedList<Integer> q = new LinkedList<Integer>();
        for (int i2 = 0; i2 < people.length; ++i2) {
            q.add(i2);
        }
        int x = 0;
        while (!q.isEmpty()) {
            x = (Integer)q.poll();
            if (q.isEmpty()) continue;
            int y = (Integer)q.poll();
            people[x].taskReduce(people[y]);
            q.add(x);
        }
        Person p1 = people[0];
        String name = p1.getName();
        int age = p1.getAge();
        int numC = p1.getNumComputers();
        System.out.println("[LOG][PSCO_MR_TARGET] Person " + name + " with age " + age + " has " + numC + " computers");
        System.out.println("[LOG][PSCO_MR_TARGET] EndId = " + p1.getID());
    }
}

