/*
 * Decompiled with CFR 0.152.
 */
package cache;

import cache.CacheImpl;
import cache.Container;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Cache {
    public static void main(String[] args) {
        if (args.length != 0) {
            System.out.println("[ERROR] Bad number of parameters");
            System.out.println("    Usage: cache.Cache");
            System.exit(-1);
        }
        Cache.check_sendParams();
        Cache.check_objectCache();
        Cache.check_fileCache();
    }

    public static void check_sendParams() {
        System.out.println("Checking send params...");
        String fileName1 = "fileSP_IN.txt";
        String fileName2 = "fileSP_INOUT.txt";
        String fileName3 = "fileSP_OUT.txt";
        Cache.writeValueFile(fileName1, 1);
        Cache.writeValueFile(fileName2, 1);
        Container c1 = new Container(1);
        Container c2 = new Container(1);
        Container c3 = CacheImpl.method(1, false, "hello", fileName1, fileName2, fileName3, c1, c2);
        int val1 = Cache.readValueFile(fileName1);
        int val2 = Cache.readValueFile(fileName2);
        int val3 = Cache.readValueFile(fileName3);
        System.out.println("- Value File IN: " + val1);
        System.out.println("- Value File INOUT: " + val2);
        System.out.println("- Value File OUT: " + val3);
        System.out.println("- Value Object IN: " + c1.getValue());
        System.out.println("- Value Object INOUT: " + c2.getValue());
        System.out.println("- Value Object OUT: " + c3.getValue());
    }

    public static void check_objectCache() {
        Cache.check_IN_objectCache();
        Cache.check_INOUT_objectCache();
        Cache.check_OUT_objectCache();
        Cache.check_MIXT_objectCache();
    }

    public static void check_fileCache() {
        Cache.check_IN_fileCache();
        Cache.check_INOUT_fileCache();
        Cache.check_OUT_fileCache();
        Cache.check_MIXT_fileCache();
    }

    private static void check_IN_objectCache() {
        System.out.println("Checking IN object Cache...");
        Container c = new Container(1);
        CacheImpl.objectIN(c);
        CacheImpl.objectIN(c);
        System.out.println("FINAL IN CONTAINER VALUE = " + c.getValue());
    }

    private static void check_INOUT_objectCache() {
        System.out.println("Checking INOUT object Cache...");
        Container c = new Container(1);
        CacheImpl.objectINOUT(c);
        CacheImpl.objectINOUT(c);
        System.out.println("FINAL INOUT CONTAINER VALUE = " + c.getValue());
    }

    private static void check_OUT_objectCache() {
        System.out.println("Checking OUT object Cache...");
        Container c = new Container(1);
        c = CacheImpl.objectOUT();
        c = CacheImpl.objectOUT();
        System.out.println("FINAL OUT CONTAINER VALUE = " + c.getValue());
    }

    private static void check_MIXT_objectCache() {
        System.out.println("Checking MIXT object Cache...");
        Container c = new Container(1);
        CacheImpl.objectIN(c);
        CacheImpl.objectINOUT(c);
        CacheImpl.objectINOUT(c);
        c = CacheImpl.objectOUT();
        System.out.println("FINAL MIXT CONTAINER VALUE = " + c.getValue());
    }

    private static void check_IN_fileCache() {
        System.out.println("Checking IN file Cache...");
        String fileName = "fileIN.txt";
        Cache.writeValueFile(fileName, 1);
        CacheImpl.fileIN(fileName);
        CacheImpl.fileIN(fileName);
        int finalValue = Cache.readValueFile(fileName);
        System.out.println("FINAL IN FILE VALUE = " + finalValue);
    }

    private static void check_INOUT_fileCache() {
        System.out.println("Checking INOUT file Cache...");
        String fileName = "fileINOUT.txt";
        Cache.writeValueFile(fileName, 1);
        CacheImpl.fileINOUT(fileName);
        CacheImpl.fileINOUT(fileName);
        int finalValue = Cache.readValueFile(fileName);
        System.out.println("FINAL INOUT FILE VALUE = " + finalValue);
    }

    private static void check_OUT_fileCache() {
        System.out.println("Checking OUT file Cache...");
        String fileName = "fileOUT.txt";
        CacheImpl.fileOUT(fileName);
        CacheImpl.fileOUT(fileName);
        int finalValue = Cache.readValueFile(fileName);
        System.out.println("FINAL IN FILE VALUE = " + finalValue);
    }

    private static void check_MIXT_fileCache() {
        System.out.println("Checking MIXT file Cache...");
        String fileName = "fileMIXT.txt";
        Cache.writeValueFile(fileName, 1);
        CacheImpl.fileIN(fileName);
        CacheImpl.fileINOUT(fileName);
        CacheImpl.fileINOUT(fileName);
        CacheImpl.fileOUT(fileName);
        int finalValue = Cache.readValueFile(fileName);
        System.out.println("FINAL MIXT FILE VALUE = " + finalValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValueFile(String fileName, int value) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fos.write(value);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    System.exit(-1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int readValueFile(String fileName) {
        FileInputStream fis = null;
        int value = -1;
        try {
            fis = new FileInputStream(fileName);
            value = fis.read();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    System.exit(-1);
                }
            }
        }
        return value;
    }
}

