/*
 * Decompiled with CFR 0.152.
 */
package simple;

import integratedtoolkit.util.ResourceManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import simple.SimpleImpl;

public class Simple {
    private static final String counterName = "counter";

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("[ERROR] Incorrect number of parameters");
            System.out.println("    Usage simple <initVal> <increment> <minVM> <maxVM> <creationTime>");
            System.exit(-1);
        }
        try {
            int i;
            int initialValue = Integer.parseInt(args[0]);
            int increment = Integer.parseInt(args[1]);
            int minVM = Integer.parseInt(args[2]);
            int maxVM = Integer.parseInt(args[3]);
            int creationTime = Integer.parseInt(args[4]);
            System.out.println("[LOG] Initial counter value is " + initialValue);
            System.out.println("[LOG] Minimal VM is " + minVM);
            System.out.println("[LOG] Maximal VM is " + maxVM);
            System.out.println("[LOG] Creating VM time is " + creationTime);
            int currentRes = ResourceManager.getAllWorkers().size();
            System.out.println("[LOG] Initial number of resources is " + currentRes);
            if (currentRes != 0) {
                System.out.println("FAIL: Initial Resources incorrect " + currentRes);
                System.exit(-1);
            } else {
                System.out.println("** Initial Resource detection  OK **");
            }
            System.out.println("[LOG] Creating minimal number of VM's. Waiting...");
            for (i = 0; i <= minVM; ++i) {
                try {
                    Thread.sleep(creationTime * 1000);
                    continue;
                }
                catch (InterruptedException e) {
                    System.out.println("FAIL: Cannot sleep current thread");
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            System.out.println("[LOG] Checking initial number of VMs " + minVM);
            currentRes = ResourceManager.getAllWorkers().size();
            if (currentRes != minVM) {
                System.out.println("FAIL: Initial VMs incorrect " + currentRes + " (" + minVM + ")");
                System.exit(-1);
            } else {
                System.out.println("** Initial VM creation  OK **");
            }
            System.out.println("[LOG] Sending increment executions");
            for (i = 0; i < increment; ++i) {
                FileOutputStream fos = new FileOutputStream(counterName + i);
                fos.write(initialValue);
                fos.close();
                SimpleImpl.increment(counterName + i);
            }
            for (i = 0; i < increment; ++i) {
                FileInputStream fis = new FileInputStream(counterName + i);
                int finalValue = fis.read();
                int expected = initialValue + 1;
                System.out.println("[LOG] Final counter" + i + " value is " + finalValue + " (expected: " + expected + ")");
                fis.close();
                if (finalValue == expected) continue;
                System.out.println("FAIL: Incorrect final value at counter" + i);
                System.exit(-1);
            }
            System.out.println("[ATTENTION] Elasticity on VM's must be checked on result script");
            System.out.println("** Application values OK **");
            Thread.sleep(120000L);
        }
        catch (Exception ioe) {
            System.out.println("[ERROR] Exception found");
            ioe.printStackTrace();
            System.exit(-1);
        }
    }
}

