/*
 * Decompiled with CFR 0.152.
 */
package nonNativeTasks;

import binary.BINARY;
import integratedtoolkit.api.COMPSs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Main {
    private static final int WAIT_RUNTIME = 5000;
    private static final String fileIn = "input.txt";
    private static final String fileOut = "output.txt";
    private static final String fileErr = "error.txt";
    private static String message;
    private static String input;

    public static void main(String[] args) {
        System.out.println("[LOG] Initialize data");
        Main.initializeData();
        System.out.println("[LOG] Wait for Runtime to be ready");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("");
        System.out.println("[LOG] Test Return Types");
        Main.testReturnType();
        System.out.println("");
        System.out.println("[LOG] Test prefixes");
        Main.testPrefixes();
        System.out.println("");
        System.out.println("[LOG] Test INPUT Redirection");
        Main.testInputRedirection();
        System.out.println("");
        System.out.println("[LOG] Test OUTPUT Redirection");
        Main.testOutputRedirection();
        System.out.println("");
        System.out.println("[LOG] Test ERROR Redirection");
        Main.testErrorRedirection();
        System.out.println("");
        System.out.println("[LOG] Test Complex mode");
        Main.testComplexCalls();
        System.out.println("");
        System.out.println("[LOG] Non-Native tasks Test finished");
    }

    private static void initializeData() {
        message = "Hello World";
        input = "Good Bye";
        try (BufferedWriter outputWriter = new BufferedWriter(new FileWriter(fileIn));){
            outputWriter.write(input);
            outputWriter.newLine();
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Cannot write data file input.txt");
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    private static void testReturnType() {
        System.out.println("[LOG] Launch EV");
        BINARY.simpleTask1(message);
        COMPSs.barrier();
        System.out.println("[LOG] Launch EV");
        int ev = BINARY.simpleTask2(message);
        System.out.println("[LOG] EV = " + ev);
        System.out.println("[LOG] Launch EV");
        Integer ev2 = BINARY.simpleTask3(message);
        System.out.println("[LOG] EV = " + ev2);
    }

    private static void testPrefixes() {
        System.out.println("[LOG] Launch Prefixes");
        BINARY.taskWithPrefix(message);
        COMPSs.barrier();
    }

    private static void testInputRedirection() {
        System.out.println("[LOG] Launch FILE IN redirection");
        BINARY.taskSTDINFileRedirection(message, fileIn);
        System.out.println("[LOG] Wait for FILE IN redirection");
        COMPSs.barrier();
        System.out.println("[LOG] Launch FILE IN redirection and EV");
        int ev = BINARY.taskSTDINFileRedirectionWithEV(message, fileIn);
        System.out.println("[LOG] FILE IN - EV = " + ev);
    }

    private static void testOutputRedirection() {
        String line3;
        BufferedReader br;
        Object line2;
        System.out.println("[LOG] Launch FILE OUT redirection");
        BINARY.taskSTDOUTFileRedirection(message, fileOut);
        System.out.println("[LOG] Content FILE OUT redirection:");
        try (BufferedReader br2 = new BufferedReader(new FileReader(fileOut));){
            line2 = null;
            while ((line2 = br2.readLine()) != null) {
                System.out.println((String)line2);
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE OUT redirection and EV");
        int ev = BINARY.taskSTDOUTFileRedirectionWithEV(message, fileOut);
        System.out.println("[LOG] FILE OUT redirection - EV = " + ev);
        System.out.println("[LOG] Content FILE OUT redirection - EV:");
        try {
            br = new BufferedReader(new FileReader(fileOut));
            line2 = null;
            try {
                line3 = null;
                while ((line3 = br.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            catch (Throwable line3) {
                line2 = line3;
                throw line3;
            }
            finally {
                if (br != null) {
                    if (line2 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable line3) {
                            ((Throwable)line2).addSuppressed(line3);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE OUT redirection append");
        BINARY.taskSTDOUTFileRedirectionAppend(message, fileOut);
        System.out.println("[LOG] Content FILE OUT redirection append:");
        try {
            br = new BufferedReader(new FileReader(fileOut));
            line2 = null;
            try {
                line3 = null;
                while ((line3 = br.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            catch (Throwable throwable) {
                line2 = throwable;
                throw throwable;
            }
            finally {
                if (br != null) {
                    if (line2 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)line2).addSuppressed(throwable);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE OUT redirection append and EV");
        int ev2 = BINARY.taskSTDOUTFileRedirectionWithEVAppend(message, fileOut);
        System.out.println("[LOG] FILE OUT redirection append - EV = " + ev2);
        System.out.println("[LOG] Content FILE OUT redirection append - EV:");
        try (BufferedReader br3 = new BufferedReader(new FileReader(fileOut));){
            String line4 = null;
            while ((line4 = br3.readLine()) != null) {
                System.out.println(line4);
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
    }

    private static void testErrorRedirection() {
        String line3;
        BufferedReader br;
        Object line2;
        System.out.println("[LOG] Launch FILE ERR redirection");
        BINARY.taskSTDERRFileRedirection(message, fileErr);
        System.out.println("[LOG] Content FILE ERR redirection:");
        try (BufferedReader br2 = new BufferedReader(new FileReader(fileErr));){
            line2 = null;
            while ((line2 = br2.readLine()) != null) {
                System.out.println((String)line2);
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE ERR redirection and EV");
        int ev = BINARY.taskSTDERRFileRedirectionWithEV(message, fileErr);
        System.out.println("[LOG] FILE ERR redirection - EV = " + ev);
        System.out.println("[LOG] Content FILE ERR redirection - EV:");
        try {
            br = new BufferedReader(new FileReader(fileErr));
            line2 = null;
            try {
                line3 = null;
                while ((line3 = br.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            catch (Throwable line3) {
                line2 = line3;
                throw line3;
            }
            finally {
                if (br != null) {
                    if (line2 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable line3) {
                            ((Throwable)line2).addSuppressed(line3);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE ERR redirection append");
        BINARY.taskSTDERRFileRedirectionAppend(message, fileErr);
        System.out.println("[LOG] Content FILE ERR redirection append:");
        try {
            br = new BufferedReader(new FileReader(fileErr));
            line2 = null;
            try {
                line3 = null;
                while ((line3 = br.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            catch (Throwable throwable) {
                line2 = throwable;
                throw throwable;
            }
            finally {
                if (br != null) {
                    if (line2 != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)line2).addSuppressed(throwable);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE ERR redirection append and EV");
        int ev2 = BINARY.taskSTDERRFileRedirectionWithEVAppend(message, fileErr);
        System.out.println("[LOG] FILE ERR redirection append - EV = " + ev2);
        System.out.println("[LOG] Content FILE ERR redirection append - EV:");
        try (BufferedReader br3 = new BufferedReader(new FileReader(fileErr));){
            String line4 = null;
            while ((line4 = br3.readLine()) != null) {
                System.out.println(line4);
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
    }

    private static void testComplexCalls() {
        String line3;
        Throwable throwable;
        BufferedReader br;
        String line22;
        Throwable throwable2;
        BufferedReader br2;
        System.out.println("[LOG] Launch FULL redirection");
        BINARY.fullTask1(message, fileIn, fileOut, fileErr);
        System.out.println("[LOG] Content FULL OUT:");
        try {
            br2 = new BufferedReader(new FileReader(fileOut));
            throwable2 = null;
            try {
                line22 = null;
                while ((line22 = br2.readLine()) != null) {
                    System.out.println(line22);
                }
            }
            catch (Throwable line22) {
                throwable2 = line22;
                throw line22;
            }
            finally {
                if (br2 != null) {
                    if (throwable2 != null) {
                        try {
                            br2.close();
                        }
                        catch (Throwable line22) {
                            throwable2.addSuppressed(line22);
                        }
                    } else {
                        br2.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Content FULL ERR:");
        try {
            br2 = new BufferedReader(new FileReader(fileErr));
            throwable2 = null;
            try {
                line22 = null;
                while ((line22 = br2.readLine()) != null) {
                    System.out.println(line22);
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (br2 != null) {
                    if (throwable2 != null) {
                        try {
                            br2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        br2.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FULL2 redirection");
        int ev = BINARY.fullTask2(message, fileIn, fileOut, fileErr);
        System.out.println("[LOG] FULL2 - EV = " + ev);
        System.out.println("[LOG] Content FULL2 OUT:");
        try {
            br = new BufferedReader(new FileReader(fileOut));
            throwable = null;
            try {
                line3 = null;
                while ((line3 = br.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            catch (Throwable line3) {
                throwable = line3;
                throw line3;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable line3) {
                            throwable.addSuppressed(line3);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Content FULL2 ERR:");
        try {
            br = new BufferedReader(new FileReader(fileErr));
            throwable = null;
            try {
                line3 = null;
                while ((line3 = br.readLine()) != null) {
                    System.out.println(line3);
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
    }
}

