/*
 * Decompiled with CFR 0.152.
 */
package nonNativeTasks;

import binary.BINARY;
import es.bsc.compss.api.COMPSs;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import nonNativeTasks.FileDumper;

public class Main {
    private static final int WAIT_RUNTIME = 5000;
    private static final String FILE_IN = "input.txt";
    private static final String FILE_OUT = "output.txt";
    private static final String FILE_ERR = "error.txt";
    private static String message;
    private static String input;

    public static void main(String[] args) {
        System.out.println("[LOG] Initialize data");
        Main.initializeData();
        System.out.println("[LOG] Wait for Runtime to be ready");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("");
        System.out.println("[LOG] Test Return Types");
        Main.testReturnType();
        System.out.println("");
        System.out.println("[LOG] Test prefixes");
        Main.testPrefixes();
        System.out.println("");
        System.out.println("[LOG] Test INPUT Redirection");
        Main.testInputRedirection();
        System.out.println("");
        System.out.println("[LOG] Test OUTPUT Redirection");
        Main.testOutputRedirection();
        System.out.println("");
        System.out.println("[LOG] Test ERROR Redirection");
        Main.testErrorRedirection();
        System.out.println("");
        System.out.println("[LOG] Test Complex mode");
        Main.testComplexCalls();
        System.out.println("");
        System.out.println("[LOG] Non-Native tasks Test finished");
    }

    private static void initializeData() {
        message = "Hello World";
        input = "Good Bye";
        try (BufferedWriter outputWriter = new BufferedWriter(new FileWriter(FILE_IN));){
            outputWriter.write(input);
            outputWriter.newLine();
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Cannot write data file input.txt");
            ioe.printStackTrace();
            System.exit(1);
        }
    }

    private static void testReturnType() {
        System.out.println("[LOG] Launch EV");
        BINARY.simpleTask1(message);
        COMPSs.barrier();
        System.out.println("[LOG] Launch EV");
        int ev = BINARY.simpleTask2(message);
        System.out.println("[LOG] EV = " + ev);
        System.out.println("[LOG] Launch EV");
        Integer ev2 = BINARY.simpleTask3(message);
        System.out.println("[LOG] EV = " + ev2);
    }

    private static void testPrefixes() {
        System.out.println("[LOG] Launch Prefixes");
        BINARY.taskWithPrefix(message);
        COMPSs.barrier();
    }

    private static void testInputRedirection() {
        System.out.println("[LOG] Launch FILE IN redirection");
        BINARY.taskSTDINFileRedirection(message, FILE_IN);
        System.out.println("[LOG] Wait for FILE IN redirection");
        COMPSs.barrier();
        System.out.println("[LOG] Launch FILE IN redirection and EV");
        int ev = BINARY.taskSTDINFileRedirectionWithEV(message, FILE_IN);
        System.out.println("[LOG] FILE IN - EV = " + ev);
    }

    private static void testOutputRedirection() {
        System.out.println("[LOG] Launch FILE OUT redirection");
        BINARY.taskSTDOUTFileRedirection(message, FILE_OUT);
        try {
            FileDumper.dumpFile("[LOG] Content FILE OUT redirection:", FILE_OUT);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE OUT redirection and EV");
        int ev = BINARY.taskSTDOUTFileRedirectionWithEV(message, FILE_OUT);
        System.out.println("[LOG] FILE OUT redirection - EV = " + ev);
        try {
            FileDumper.dumpFile("[LOG] Content FILE OUT redirection - EV:", FILE_OUT);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE OUT redirection append");
        BINARY.taskSTDOUTFileRedirectionAppend(message, FILE_OUT);
        try {
            FileDumper.dumpFile("[LOG] Content FILE OUT redirection append:", FILE_OUT);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE OUT redirection append and EV");
        int ev2 = BINARY.taskSTDOUTFileRedirectionWithEVAppend(message, FILE_OUT);
        System.out.println("[LOG] FILE OUT redirection append - EV = " + ev2);
        try {
            FileDumper.dumpFile("[LOG] Content FILE OUT redirection append - EV:", FILE_OUT);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
    }

    private static void testErrorRedirection() {
        System.out.println("[LOG] Launch FILE ERR redirection");
        BINARY.taskSTDERRFileRedirection(message, FILE_ERR);
        try {
            FileDumper.dumpFile("[LOG] Content FILE ERR redirection:", FILE_ERR);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE ERR redirection and EV");
        int ev = BINARY.taskSTDERRFileRedirectionWithEV(message, FILE_ERR);
        System.out.println("[LOG] FILE ERR redirection - EV = " + ev);
        System.out.println("[LOG] Content FILE ERR redirection - EV:");
        try {
            FileDumper.dumpFile("[LOG] Content FILE ERR redirection - EV:", FILE_ERR);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE ERR redirection append");
        BINARY.taskSTDERRFileRedirectionAppend(message, FILE_ERR);
        System.out.println("[LOG] Content FILE ERR redirection append:");
        try {
            FileDumper.dumpFile("[LOG] Content FILE ERR redirection append:", FILE_ERR);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FILE ERR redirection append and EV");
        int ev2 = BINARY.taskSTDERRFileRedirectionWithEVAppend(message, FILE_ERR);
        System.out.println("[LOG] FILE ERR redirection append - EV = " + ev2);
        try {
            FileDumper.dumpFile("[LOG] Content FILE ERR redirection append - EV:", FILE_ERR);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
    }

    private static void testComplexCalls() {
        System.out.println("[LOG] Launch FULL redirection");
        BINARY.fullTask1(message, FILE_IN, FILE_OUT, FILE_ERR);
        try {
            FileDumper.dumpFile("[LOG] Content FULL OUT:", FILE_OUT);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        try {
            FileDumper.dumpFile("[LOG] Content FULL ERR:", FILE_ERR);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
        System.out.println("[LOG] Launch FULL2 redirection");
        int ev = BINARY.fullTask2(message, FILE_IN, FILE_OUT, FILE_ERR);
        System.out.println("[LOG] FULL2 - EV = " + ev);
        try {
            FileDumper.dumpFile("[LOG] Content FULL2 OUT:", FILE_OUT);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file output.txt");
            System.exit(1);
        }
        try {
            FileDumper.dumpFile("[LOG] Content FULL2 ERR:", FILE_ERR);
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error reading file error.txt");
            System.exit(1);
        }
    }
}

