/*
 * Decompiled with CFR 0.152.
 */
package schedulerData;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import schedulerData.MainImpl;

public class Main {
    private static final String FILE_NAME = "counterFile_";
    private static final int SLEEP_WAIT_FOR_RUNTIME = 15000;

    private static void generateTree(int taskWidth, int taskChilds, String fileInout, String fileIn) {
        if (taskWidth == 0) {
            return;
        }
        String file2 = fileInout + taskWidth + 0;
        try {
            FileOutputStream fos = new FileOutputStream(file2);
            fos.write(taskWidth);
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
        MainImpl.increment(fileInout, fileIn);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (int i = 1; i < taskChilds; ++i) {
            file2 = fileInout + taskWidth + i;
            try {
                FileOutputStream fos = new FileOutputStream(file2);
                fos.write(taskWidth);
                fos.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(-1);
            }
            Main.generateTree(taskWidth - 1, taskChilds, file2, fileInout);
        }
        Main.generateTree(taskWidth - 1, taskChilds, fileInout, fileIn);
    }

    public static void main(String[] args) {
        String counterName;
        int i;
        if (args.length != 4) {
            System.out.println("[ERROR] Bad number of parameters");
            System.out.println("    Usage: schedulers.Main <taskWidth> <taskDepth> <counterValue>");
            System.exit(-1);
        }
        int taskWidth = Integer.parseInt(args[0]);
        int taskDepth = Integer.parseInt(args[1]);
        int taskChilds = Integer.parseInt(args[2]);
        int initialValue = Integer.parseInt(args[3]);
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (i = 0; i < taskWidth; ++i) {
            FileOutputStream fos;
            counterName = FILE_NAME + i;
            System.out.println("[INFO] Creating task " + i + " on file " + counterName + " with value " + initialValue);
            try {
                fos = new FileOutputStream(counterName);
                fos.write(initialValue);
                fos.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(-1);
            }
            counterName = FILE_NAME + i + 1;
            System.out.println("[INFO] Creating task " + i + " on file " + counterName + " with value " + initialValue);
            try {
                fos = new FileOutputStream(counterName);
                fos.write(initialValue);
                fos.close();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(-1);
            }
        }
        for (i = 0; i < taskWidth; ++i) {
            String file1 = FILE_NAME + i;
            String file2 = FILE_NAME + i + 1;
            Main.generateTree(taskDepth, taskChilds, file1, file2);
        }
        for (i = 0; i < taskWidth; ++i) {
            counterName = FILE_NAME + i;
            try {
                FileInputStream fis = new FileInputStream(counterName);
                System.out.println("[INFO] Final counter value on file " + counterName + " is " + fis.read());
                fis.close();
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

