/*
 * Decompiled with CFR 0.152.
 */
package workerEnvironment;

import workerEnvironment.MainImpl;

public class Main {
    private static final String CLASSPATH = "CLASSPATH";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";

    private static boolean checkEnvironment(String variable, String expected) {
        String variableValue = System.getenv(variable);
        System.out.println("Checking " + variable);
        System.out.println(" - Got: " + variableValue);
        System.out.println(" - Exp: " + expected);
        return variableValue.contains(expected);
    }

    public static boolean checkAllEnv(String extraCPExpected, String extraPPExpected, String extraLPExpected) {
        if (!Main.checkEnvironment(CLASSPATH, extraCPExpected)) {
            System.err.println("ERROR: Classpath variable not set correctly");
            return false;
        }
        if (!Main.checkEnvironment(LD_LIBRARY_PATH, extraLPExpected)) {
            System.err.println("ERROR: Library Path variable not set correctly");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String extraCPmasterExpected = args[0];
        String extraPPmasterExpected = args[1];
        String extraLPmasterExpected = args[2];
        if (!Main.checkAllEnv(extraCPmasterExpected, extraPPmasterExpected, extraLPmasterExpected)) {
            System.err.println("ERROR: Invalid Master environment");
            return;
        }
        if (!MainImpl.checkWorkerEnv()) {
            System.err.println("ERROR: Invalid Worker environment");
            return;
        }
        System.out.println("[LOG] ALL ENVIRONMENT OK");
    }
}

