/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ListOffsetRequest
extends AbstractRequest {
    public static final long EARLIEST_TIMESTAMP = -2L;
    public static final long LATEST_TIMESTAMP = -1L;
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEBUGGING_REPLICA_ID = -2;
    private static final String REPLICA_ID_KEY_NAME = "replica_id";
    private static final String ISOLATION_LEVEL_KEY_NAME = "isolation_level";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String TIMESTAMP_KEY_NAME = "timestamp";
    private static final String MAX_NUM_OFFSETS_KEY_NAME = "max_num_offsets";
    private static final Schema LIST_OFFSET_REQUEST_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("timestamp", Type.INT64, "Timestamp."), new Field("max_num_offsets", Type.INT32, "Maximum offsets to return."));
    private static final Schema LIST_OFFSET_REQUEST_PARTITION_V1 = new Schema(CommonFields.PARTITION_ID, new Field("timestamp", Type.INT64, "The target timestamp for the partition."));
    private static final Schema LIST_OFFSET_REQUEST_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(LIST_OFFSET_REQUEST_PARTITION_V0), "Partitions to list offset."));
    private static final Schema LIST_OFFSET_REQUEST_TOPIC_V1 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(LIST_OFFSET_REQUEST_PARTITION_V1), "Partitions to list offset."));
    private static final Schema LIST_OFFSET_REQUEST_V0 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("topics", new ArrayOf(LIST_OFFSET_REQUEST_TOPIC_V0), "Topics to list offsets."));
    private static final Schema LIST_OFFSET_REQUEST_V1 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("topics", new ArrayOf(LIST_OFFSET_REQUEST_TOPIC_V1), "Topics to list offsets."));
    private static final Schema LIST_OFFSET_REQUEST_V2 = new Schema(new Field("replica_id", Type.INT32, "Broker id of the follower. For normal consumers, use -1."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(LIST_OFFSET_REQUEST_TOPIC_V1), "Topics to list offsets."));
    private final int replicaId;
    private final IsolationLevel isolationLevel;
    private final Map<TopicPartition, PartitionData> offsetData;
    private final Map<TopicPartition, Long> partitionTimestamps;
    private final Set<TopicPartition> duplicatePartitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{LIST_OFFSET_REQUEST_V0, LIST_OFFSET_REQUEST_V1, LIST_OFFSET_REQUEST_V2};
    }

    private ListOffsetRequest(int replicaId, Map<TopicPartition, ?> targetTimes, IsolationLevel isolationLevel, short version) {
        super(version);
        this.replicaId = replicaId;
        this.isolationLevel = isolationLevel;
        this.offsetData = version == 0 ? targetTimes : null;
        this.partitionTimestamps = version >= 1 ? targetTimes : null;
        this.duplicatePartitions = Collections.emptySet();
    }

    public ListOffsetRequest(Struct struct, short version) {
        super(version);
        HashSet<TopicPartition> duplicatePartitions = new HashSet<TopicPartition>();
        this.replicaId = struct.getInt(REPLICA_ID_KEY_NAME);
        this.isolationLevel = struct.hasField(ISOLATION_LEVEL_KEY_NAME) ? IsolationLevel.forId(struct.getByte(ISOLATION_LEVEL_KEY_NAME)) : IsolationLevel.READ_UNCOMMITTED;
        this.offsetData = new HashMap<TopicPartition, PartitionData>();
        this.partitionTimestamps = new HashMap<TopicPartition, Long>();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                long timestamp = partitionResponse.getLong(TIMESTAMP_KEY_NAME);
                TopicPartition tp = new TopicPartition(topic, partition);
                if (partitionResponse.hasField(MAX_NUM_OFFSETS_KEY_NAME)) {
                    int maxNumOffsets = partitionResponse.getInt(MAX_NUM_OFFSETS_KEY_NAME);
                    PartitionData partitionData = new PartitionData(timestamp, maxNumOffsets);
                    this.offsetData.put(tp, partitionData);
                    continue;
                }
                if (this.partitionTimestamps.put(tp, timestamp) == null) continue;
                duplicatePartitions.add(tp);
            }
        }
        this.duplicatePartitions = duplicatePartitions;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, ListOffsetResponse.PartitionData> responseData = new HashMap<TopicPartition, ListOffsetResponse.PartitionData>();
        short versionId = this.version();
        if (versionId == 0) {
            for (Map.Entry<TopicPartition, PartitionData> entry : this.offsetData.entrySet()) {
                ListOffsetResponse.PartitionData partitionResponse = new ListOffsetResponse.PartitionData(Errors.forException(e), Collections.emptyList());
                responseData.put(entry.getKey(), partitionResponse);
            }
        } else {
            for (Map.Entry<TopicPartition, Long> entry : this.partitionTimestamps.entrySet()) {
                ListOffsetResponse.PartitionData partitionResponse = new ListOffsetResponse.PartitionData(Errors.forException(e), -1L, -1L);
                responseData.put(entry.getKey(), partitionResponse);
            }
        }
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new ListOffsetResponse(throttleTimeMs, responseData);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LIST_OFFSETS.latestVersion()));
    }

    public int replicaId() {
        return this.replicaId;
    }

    public IsolationLevel isolationLevel() {
        return this.isolationLevel;
    }

    @Deprecated
    public Map<TopicPartition, PartitionData> offsetData() {
        return this.offsetData;
    }

    public Map<TopicPartition, Long> partitionTimestamps() {
        return this.partitionTimestamps;
    }

    public Set<TopicPartition> duplicatePartitions() {
        return this.duplicatePartitions;
    }

    public static ListOffsetRequest parse(ByteBuffer buffer, short version) {
        return new ListOffsetRequest(ApiKeys.LIST_OFFSETS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.LIST_OFFSETS.requestSchema(version));
        Map<TopicPartition, Object> targetTimes = this.partitionTimestamps == null ? this.offsetData : this.partitionTimestamps;
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(targetTimes);
        struct.set(REPLICA_ID_KEY_NAME, (Object)this.replicaId);
        if (struct.hasField(ISOLATION_LEVEL_KEY_NAME)) {
            struct.set(ISOLATION_LEVEL_KEY_NAME, (Object)this.isolationLevel.id());
        }
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = struct.instance(TOPICS_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                Struct partitionData;
                if (version == 0) {
                    PartitionData offsetPartitionData = partitionEntry.getValue();
                    partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                    partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)offsetPartitionData.timestamp);
                    partitionData.set(MAX_NUM_OFFSETS_KEY_NAME, (Object)offsetPartitionData.maxNumOffsets);
                    partitionArray.add(partitionData);
                    continue;
                }
                Long timestamp = (Long)((Object)partitionEntry.getValue());
                partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(TIMESTAMP_KEY_NAME, (Object)timestamp);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        return struct;
    }

    @Deprecated
    public static final class PartitionData {
        public final long timestamp;
        public final int maxNumOffsets;

        public PartitionData(long timestamp, int maxNumOffsets) {
            this.timestamp = timestamp;
            this.maxNumOffsets = maxNumOffsets;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("{timestamp: ").append(this.timestamp).append(", maxNumOffsets: ").append(this.maxNumOffsets).append("}");
            return bld.toString();
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<ListOffsetRequest> {
        private final int replicaId;
        private final IsolationLevel isolationLevel;
        private Map<TopicPartition, PartitionData> offsetData = null;
        private Map<TopicPartition, Long> partitionTimestamps = null;

        public static Builder forReplica(short allowedVersion, int replicaId) {
            return new Builder(0, allowedVersion, replicaId, IsolationLevel.READ_UNCOMMITTED);
        }

        public static Builder forConsumer(boolean requireTimestamp, IsolationLevel isolationLevel) {
            short minVersion = 0;
            if (isolationLevel == IsolationLevel.READ_COMMITTED) {
                minVersion = 2;
            } else if (requireTimestamp) {
                minVersion = 1;
            }
            return new Builder(minVersion, ApiKeys.LIST_OFFSETS.latestVersion(), -1, isolationLevel);
        }

        private Builder(short oldestAllowedVersion, short latestAllowedVersion, int replicaId, IsolationLevel isolationLevel) {
            super(ApiKeys.LIST_OFFSETS, oldestAllowedVersion, latestAllowedVersion);
            this.replicaId = replicaId;
            this.isolationLevel = isolationLevel;
        }

        public Builder setOffsetData(Map<TopicPartition, PartitionData> offsetData) {
            this.offsetData = offsetData;
            return this;
        }

        public Builder setTargetTimes(Map<TopicPartition, Long> partitionTimestamps) {
            this.partitionTimestamps = partitionTimestamps;
            return this;
        }

        @Override
        public ListOffsetRequest build(short version) {
            if (version == 0) {
                if (this.offsetData == null) {
                    if (this.partitionTimestamps == null) {
                        throw new RuntimeException("Must set partitionTimestamps or offsetData when creating a v0 ListOffsetRequest");
                    }
                    this.offsetData = new HashMap<TopicPartition, PartitionData>();
                    for (Map.Entry<TopicPartition, Long> entry : this.partitionTimestamps.entrySet()) {
                        this.offsetData.put(entry.getKey(), new PartitionData(entry.getValue(), 1));
                    }
                    this.partitionTimestamps = null;
                }
            } else {
                if (this.offsetData != null) {
                    throw new RuntimeException("Cannot create a v" + version + " ListOffsetRequest with v0 " + "PartitionData.");
                }
                if (this.partitionTimestamps == null) {
                    throw new RuntimeException("Must set partitionTimestamps when creating a v" + version + " ListOffsetRequest");
                }
            }
            Map<TopicPartition, Object> m = version == 0 ? this.offsetData : this.partitionTimestamps;
            return new ListOffsetRequest(this.replicaId, m, this.isolationLevel, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ListOffsetRequest").append(", replicaId=").append(this.replicaId);
            if (this.offsetData != null) {
                bld.append(", offsetData=").append(this.offsetData);
            }
            if (this.partitionTimestamps != null) {
                bld.append(", partitionTimestamps=").append(this.partitionTimestamps);
            }
            bld.append(", isolationLevel=").append((Object)this.isolationLevel);
            bld.append(")");
            return bld.toString();
        }
    }
}

