/*
 * Decompiled with CFR 0.152.
 */
package streams.components;

import java.util.Locale;
import streams.components.COMPSsStream;
import streams.components.exceptions.AnnounceException;
import streams.components.exceptions.InvalidCredentialsException;
import streams.components.utils.RegistrationId;

public class Producer {
    private static final int FREQ_STATS_MSG = 1000;
    private static final int FREQ_WAIT_TIME = 10000;
    private static final int WAIT_TIME = 200;
    private static final boolean DEBUG = false;

    public static Integer sendMessages(COMPSsStream stream, int numMessages) {
        RegistrationId id = null;
        try {
            id = stream.announce();
        }
        catch (AnnounceException ae) {
            System.err.println("ERROR: Cannot announce publication");
            ae.printStackTrace();
            return -1;
        }
        for (int i = 0; i < numMessages; ++i) {
            String msg = String.format(Locale.ROOT, "{\"type\":\"message\", \"t\":%.3f, \"k\":%d}", (double)System.nanoTime() * 1.0E-9, i);
            try {
                stream.publish(id, "regular-messages", msg);
            }
            catch (InvalidCredentialsException ice) {
                System.err.println("ERROR: Cannot send regular message");
                ice.printStackTrace();
                return -1;
            }
            if (i % 1000 == 0) {
                String statMsg = String.format(Locale.ROOT, "{\"type\":\"stats\", \"t\":%.3f, \"k\":%d}", (double)System.nanoTime() * 1.0E-9, i);
                try {
                    stream.publish(id, "regular-messages", statMsg);
                }
                catch (InvalidCredentialsException ice) {
                    System.err.println("ERROR: Cannot send stat message");
                    ice.printStackTrace();
                    return -1;
                }
            }
            if (i % 10000 != 0) continue;
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        String endMsg = String.format(Locale.ROOT, "{\"type\":\"end\", \"t\":%.3f, \"k\":%d}", (double)System.nanoTime() * 1.0E-9, 0);
        try {
            stream.publish(id, "system-messages", endMsg);
        }
        catch (InvalidCredentialsException ice) {
            System.err.println("ERROR: Cannot send end message");
            ice.printStackTrace();
            return -1;
        }
        try {
            stream.close(id);
        }
        catch (InvalidCredentialsException ice) {
            System.err.println("ERROR: Cannot close stream");
            ice.printStackTrace();
            return -1;
        }
        return 0;
    }
}

