/*
 * Decompiled with CFR 0.152.
 */
package threadConcurrent;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import threadConcurrent.ConcurrentImpl;

public class Concurrent
extends Thread {
    private static int NUM_THREADS = 2;
    private String counterName = "counter";
    private int value;

    public Concurrent() {
        this.value = 0;
    }

    public Concurrent(int initVal) {
        this.value = initVal;
        this.counterName = "counter" + String.valueOf(this.value);
    }

    @Override
    public void run() {
        try {
            FileOutputStream fos = new FileOutputStream(this.counterName);
            fos.write(this.value);
            System.out.println("Initial counter value is " + this.value);
            fos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
        ConcurrentImpl.increment(this.counterName);
        try {
            FileInputStream fis = new FileInputStream(this.counterName);
            System.out.println("Final counter value is " + fis.read());
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        int i;
        if (args.length != 1) {
            System.err.println("[ERROR] Bad number of parameters");
            System.err.println("    Usage: threadConcurrent.Concurrent <counterValue>");
            System.exit(-1);
        }
        int initialValue = Integer.parseInt(args[0]);
        Concurrent[] threads = new Concurrent[NUM_THREADS];
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i] = new Concurrent(initialValue);
            threads[i].start();
            ++initialValue;
        }
        for (i = 0; i < NUM_THREADS; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                System.err.println("[ERROR] Interrupted thread");
                System.exit(-1);
            }
        }
    }
}

