/*
 * Decompiled with CFR 0.152.
 */
package fileStreamTest;

import es.bsc.distrostreamlib.api.files.FileDistroStream;
import es.bsc.distrostreamlib.exceptions.BackendException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;

public class Tasks {
    public static void writeFiles(FileDistroStream fds, int sleepTime) {
        Tasks.writeFilesToPath("/tmp/file_stream/", sleepTime);
        fds.close();
    }

    public static void writeFilesAlias(FileDistroStream fds, int sleepTime) {
        Tasks.writeFilesToPath("/tmp/file_custom_stream/", sleepTime);
        fds.close();
    }

    public static void writeFilesToPath(String basePath, int sleepTime) {
        for (int i = 0; i < 10; ++i) {
            String fileName = basePath + File.separator + "file" + UUID.randomUUID();
            try (PrintWriter writer = new PrintWriter(fileName);){
                System.out.println("WRITING FILE: " + fileName);
                writer.write("Test " + String.valueOf(i));
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Cannot write file " + fileName);
                fnfe.printStackTrace();
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static Integer readFiles(FileDistroStream fds, int sleepTime) throws IOException, BackendException {
        Integer numNewFiles;
        Integer totalFiles = 0;
        while (!fds.isClosed()) {
            numNewFiles = Tasks.pollNewFiles(fds);
            totalFiles = totalFiles + numNewFiles;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        numNewFiles = Tasks.pollNewFiles(fds);
        totalFiles = totalFiles + numNewFiles;
        return totalFiles;
    }

    private static Integer pollNewFiles(FileDistroStream fds) throws IOException, BackendException {
        List<String> newFiles = fds.poll();
        for (String fileName : newFiles) {
            System.out.println("RECEIVED FILE: " + fileName);
            String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
            System.out.println(content);
        }
        return newFiles.size();
    }

    public static Integer processFile(String fileName) throws IOException {
        System.out.println("RECEIVED FILE: " + fileName);
        String content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
        System.out.println(content);
        return 1;
    }
}

