/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.distrostreamlib.api.objects;

import es.bsc.distrostreamlib.api.objects.ODSProperties;
import es.bsc.distrostreamlib.exceptions.BackendException;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ODSPublisher<T> {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.distroStreamLib.stream.ObjectDistroStream.Publisher");
    private final KafkaProducer<String, T> kafkaProducer;

    public ODSPublisher(String bootstrapServer) throws BackendException {
        LOGGER.debug("Creating Publisher...");
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServer);
        properties.putAll(ODSProperties.DEFAULT_PRODUCER_PROPERTIES);
        this.kafkaProducer = new KafkaProducer(properties);
        LOGGER.debug("DONE Creating Publisher");
    }

    public void publish(String topic, T message) {
        LOGGER.debug("Publishing Message to " + topic + " ...");
        ProducerRecord record = new ProducerRecord(topic, message);
        this.kafkaProducer.send(record);
        LOGGER.debug("DONE Publishing Message");
    }
}

