/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class EndTxnRequestData
implements ApiMessage {
    private String transactionalId;
    private long producerId;
    private short producerEpoch;
    private boolean committed;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public EndTxnRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public EndTxnRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public EndTxnRequestData() {
        this.transactionalId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.committed = false;
    }

    @Override
    public short apiKey() {
        return 26;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.transactionalId = readable.readNullableString();
        this.producerId = readable.readLong();
        this.producerEpoch = readable.readShort();
        this.committed = readable.readByte() != 0;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.transactionalId);
        writable.writeLong(this.producerId);
        writable.writeShort(this.producerEpoch);
        writable.writeByte(this.committed ? (byte)1 : 0);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.transactionalId = struct.getString("transactional_id");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        this.committed = struct.getBoolean("committed");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        struct.set("committed", (Object)this.committed);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.transactionalId);
        size += 8;
        size += 2;
        return ++size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EndTxnRequestData)) {
            return false;
        }
        EndTxnRequestData other = (EndTxnRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        return this.committed == other.committed;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.committed ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "EndTxnRequestData(transactionalId='" + this.transactionalId + "', producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", committed=" + (this.committed ? "true" : "false") + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public boolean committed() {
        return this.committed;
    }

    public EndTxnRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public EndTxnRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public EndTxnRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public EndTxnRequestData setCommitted(boolean v) {
        this.committed = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("transactional_id", Type.STRING, "The ID of the transaction to end."), new Field("producer_id", Type.INT64, "The producer ID."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer."), new Field("committed", Type.BOOLEAN, "True if the transaction was committed, false if it was aborted."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

