/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.worker;

import es.bsc.compss.worker.CancelReason;
import java.util.HashMap;
import java.util.Map;

public class COMPSsWorker {
    public static final String COMPSS_TASK_ID = "COMPSS_TASK_ID";
    private static final Map<Integer, CancelReason> TASKS_TO_CANCEL = new HashMap<Integer, CancelReason>();

    public static final void cancellationPoint() throws Exception {
        CancelReason exceptionReason;
        String taskIdStr = System.getProperty(COMPSS_TASK_ID);
        if (taskIdStr != null && (exceptionReason = TASKS_TO_CANCEL.get(Integer.parseInt(taskIdStr))) != null) {
            switch (exceptionReason) {
                case COMPSS_EXCEPTION: {
                    System.out.println("Task " + taskIdStr + " cancelled because a COMPSs Exception occured.");
                    throw new Exception("Task " + taskIdStr + " has been canceled.");
                }
                case TIMEOUT: {
                    System.out.println("Task " + taskIdStr + " has timed out.");
                    throw new Exception("Task " + taskIdStr + " timed out.");
                }
            }
        }
    }

    protected static final void setCancelled(int taskId, CancelReason reason) {
        TASKS_TO_CANCEL.put(taskId, reason);
    }
}

