/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;

public class DescribeConfigsResponse
extends AbstractResponse {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private static final String CONFIG_ENTRIES_KEY_NAME = "config_entries";
    private static final String CONFIG_NAME_KEY_NAME = "config_name";
    private static final String CONFIG_VALUE_KEY_NAME = "config_value";
    private static final String IS_SENSITIVE_KEY_NAME = "is_sensitive";
    private static final String IS_DEFAULT_KEY_NAME = "is_default";
    private static final String READ_ONLY_KEY_NAME = "read_only";
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_ENTITY_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING), new Field("config_entries", new ArrayOf(new Schema(new Field("config_name", Type.STRING), new Field("config_value", Type.NULLABLE_STRING), new Field("read_only", Type.BOOLEAN), new Field("is_default", Type.BOOLEAN), new Field("is_sensitive", Type.BOOLEAN)))));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("resources", new ArrayOf(DESCRIBE_CONFIGS_RESPONSE_ENTITY_V0)));
    private final int throttleTimeMs;
    private final Map<Resource, Config> configs;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_CONFIGS_RESPONSE_V0};
    }

    public DescribeConfigsResponse(int throttleTimeMs, Map<Resource, Config> configs) {
        this.throttleTimeMs = throttleTimeMs;
        this.configs = configs;
    }

    public DescribeConfigsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.configs = new HashMap<Resource, Config>(resourcesArray.length);
        for (Object resourceObj : resourcesArray) {
            Struct resourceStruct = (Struct)resourceObj;
            ApiError error = new ApiError(resourceStruct);
            ResourceType resourceType = ResourceType.forId(resourceStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourceStruct.getString(RESOURCE_NAME_KEY_NAME);
            Resource resource = new Resource(resourceType, resourceName);
            Object[] configEntriesArray = resourceStruct.getArray(CONFIG_ENTRIES_KEY_NAME);
            ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>(configEntriesArray.length);
            for (Object configEntriesObj : configEntriesArray) {
                Struct configEntriesStruct = (Struct)configEntriesObj;
                String configName = configEntriesStruct.getString(CONFIG_NAME_KEY_NAME);
                String configValue = configEntriesStruct.getString(CONFIG_VALUE_KEY_NAME);
                boolean isSensitive = configEntriesStruct.getBoolean(IS_SENSITIVE_KEY_NAME);
                boolean isDefault = configEntriesStruct.getBoolean(IS_DEFAULT_KEY_NAME);
                boolean readOnly = configEntriesStruct.getBoolean(READ_ONLY_KEY_NAME);
                configEntries.add(new ConfigEntry(configName, configValue, isSensitive, isDefault, readOnly));
            }
            Config config = new Config(error, configEntries);
            this.configs.put(resource, config);
        }
    }

    public Map<Resource, Config> configs() {
        return this.configs;
    }

    public Config config(Resource resource) {
        return this.configs.get(resource);
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (Config response : this.configs.values()) {
            this.updateErrorCounts(errorCounts, response.error.error());
        }
        return errorCounts;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_CONFIGS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.configs.size());
        for (Map.Entry<Resource, Config> entry : this.configs.entrySet()) {
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            Resource resource = entry.getKey();
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            Config config = entry.getValue();
            config.error.write(resourceStruct);
            ArrayList<Struct> configEntryStructs = new ArrayList<Struct>(config.entries.size());
            for (ConfigEntry configEntry : config.entries) {
                Struct configEntriesStruct = resourceStruct.instance(CONFIG_ENTRIES_KEY_NAME);
                configEntriesStruct.set(CONFIG_NAME_KEY_NAME, (Object)configEntry.name);
                configEntriesStruct.set(CONFIG_VALUE_KEY_NAME, (Object)configEntry.value);
                configEntriesStruct.set(IS_SENSITIVE_KEY_NAME, (Object)configEntry.isSensitive);
                configEntriesStruct.set(IS_DEFAULT_KEY_NAME, (Object)configEntry.isDefault);
                configEntriesStruct.set(READ_ONLY_KEY_NAME, (Object)configEntry.readOnly);
                configEntryStructs.add(configEntriesStruct);
            }
            resourceStruct.set(CONFIG_ENTRIES_KEY_NAME, (Object)configEntryStructs.toArray(new Struct[0]));
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        return struct;
    }

    public static DescribeConfigsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsResponse(ApiKeys.DESCRIBE_CONFIGS.parseResponse(version, buffer));
    }

    public static class ConfigEntry {
        private final String name;
        private final String value;
        private final boolean isSensitive;
        private final boolean isDefault;
        private final boolean readOnly;

        public ConfigEntry(String name, String value, boolean isSensitive, boolean isDefault, boolean readOnly) {
            this.name = name;
            this.value = value;
            this.isSensitive = isSensitive;
            this.isDefault = isDefault;
            this.readOnly = readOnly;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public boolean isSensitive() {
            return this.isSensitive;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }

    public static class Config {
        private final ApiError error;
        private final Collection<ConfigEntry> entries;

        public Config(ApiError error, Collection<ConfigEntry> entries) {
            this.error = error;
            this.entries = entries;
        }

        public ApiError error() {
            return this.error;
        }

        public Collection<ConfigEntry> entries() {
            return this.entries;
        }
    }
}

