/*
 * Decompiled with CFR 0.152.
 */
package testHttpTask;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import testHttpTask.TestHttpTaskImpl;

public class TestHttpTask {
    private static final String FILE_NAME = "text.txt";

    public static void main(String[] args) throws Exception {
        System.out.println("[LOG] Main program started.");
        TestHttpTask.testGetRequests();
        TestHttpTask.testPostRequests();
    }

    private static void testGetRequests() {
        TestHttpTaskImpl http = new TestHttpTaskImpl();
        http.testGet();
        TestHttpTask.assertAndPrint("GET: dummy", true);
        String message = "holala";
        int len = http.testGetLength(message);
        TestHttpTask.assertAndPrint("GET: getLength", len == message.length());
        String res = http.testProducesString(message);
        TestHttpTask.assertAndPrint("GET: producesString", message.equals(res));
        String ret = http.testNestedProduces(message);
        TestHttpTask.assertAndPrint("GET: testNestedProduces", ret.equals(message));
    }

    private static void testPostRequests() throws IOException {
        TestHttpTaskImpl http = new TestHttpTaskImpl();
        String res = http.testPost();
        TestHttpTask.assertAndPrint("POST: dummy", res.equals("post_works"));
        String message = "holala";
        String payload = http.testPayloadWithParam(message);
        TestHttpTask.assertAndPrint("POST: testPayload", message.equals(payload));
        TestHttpTask.newFile();
        TestHttpTask.writeInFile();
        String ret = http.testPayloadWithFileParam(FILE_NAME);
        TestHttpTask.assertAndPrint("POST: testFileParam", ret.equals("testing"));
    }

    private static void writeInFile() {
        String str = "testing";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(FILE_NAME, true));){
            writer.write(str);
        }
        catch (IOException fnfe) {
            fnfe.printStackTrace();
            System.exit(-1);
        }
    }

    private static void newFile() throws IOException {
        boolean createdFile;
        File file = new File(FILE_NAME);
        if (file.exists()) {
            file.delete();
        }
        if (!(createdFile = file.createNewFile())) {
            throw new IOException("[ERROR] Cannot create test file");
        }
    }

    private static void assertAndPrint(String testName, boolean condition) {
        if (condition) {
            System.out.println("TEST PASSED:" + testName);
        } else {
            System.out.println("TEST FAILED:" + testName);
        }
    }
}

