/*
 * Decompiled with CFR 0.152.
 */
package es.bsc;

import com.google.gson.Gson;
import es.bsc.RESTServiceLauncher;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.server.Server;
import org.json.JSONObject;

@Path(value="/test")
public class testREST {
    private int port;
    private Server server = null;

    public testREST() {
    }

    public testREST(int port) {
        this.port = port;
    }

    private synchronized void start() throws Exception {
        if (this.server != null) {
            return;
        }
        RESTServiceLauncher launcher = null;
        launcher = new RESTServiceLauncher(this.port);
        new Thread(launcher).start();
        launcher.waitForBoot();
        if (launcher.getStartError() != null) {
            throw new Exception(launcher.getStartError());
        }
        this.server = launcher.getServer();
    }

    private synchronized void stop() {
        if (this.server != null) {
            new Thread(){

                @Override
                public void run() {
                    Thread.currentThread().setName("REST Agent Service Stopper");
                    try {
                        Thread.sleep(500L);
                        testREST.this.server.stop();
                    }
                    catch (Exception ex) {
                        if (!testREST.this.server.isStopped()) {
                            testREST.this.server.destroy();
                        }
                    }
                    finally {
                        testREST.this.server = null;
                    }
                }
            }.start();
        }
    }

    @GET
    @Path(value="stop/")
    public Response shutDown() {
        this.stop();
        return this.respond("ok");
    }

    @GET
    @Path(value="dummy/")
    public Response dummy() {
        return this.stringRespond("it_works");
    }

    @GET
    @Path(value="get_length/{message}")
    public Response getLength(@PathParam(value="message") String message) {
        return this.stringRespond(message.length());
    }

    @GET
    @Path(value="print_message/{message}")
    @Produces(value={"application/json"})
    public Response print(@PathParam(value="message") String message) {
        return this.respond(message);
    }

    @POST
    @Path(value="post/")
    @Consumes(value={"application/json"})
    public Response testPost(String json) {
        return this.stringRespond("post_works");
    }

    @POST
    @Path(value="post_json/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testPostJson(String json) {
        return this.stringRespond(json);
    }

    @GET
    @Path(value="produce_format/{message}")
    @Produces(value={"application/json"})
    public Response testProduces(@PathParam(value="message") String message) {
        System.out.println("received:" + message);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("depth_0", "zero");
        jsonObject.put("length", message.length());
        JSONObject nestedJsonObject = new JSONObject();
        nestedJsonObject.put("depth_1", "one");
        nestedJsonObject.put("message", message);
        jsonObject.put("child_json", nestedJsonObject);
        return Response.ok((Object)jsonObject.toString(), "application/json").build();
    }

    private Response respond(Object message) {
        Gson gson = new Gson();
        String json = gson.toJson(message);
        return Response.ok(json).build();
    }

    private Response stringRespond(Object message) {
        return Response.ok(message).build();
    }

    public static void main(String[] args) throws Exception {
        int port = 1992;
        if (args.length == 1) {
            port = Integer.parseInt(args[0]);
        }
        testREST ra = new testREST(1992);
        ra.start();
    }
}

