/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty;

import jakarta.ws.rs.ProcessingException;
import java.net.URI;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.jetty.JettyHttpContainer;
import org.glassfish.jersey.jetty.internal.LocalizationMessages;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public final class JettyHttpContainerFactory {
    private JettyHttpContainerFactory() {
    }

    public static Server createServer(URI uri) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, true);
    }

    public static Server createServer(URI uri, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, null, start);
    }

    public static Server createServer(URI uri, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = ContainerFactory.createContainer(JettyHttpContainer.class, config);
        return JettyHttpContainerFactory.createServer(uri, null, container, true);
    }

    public static Server createServer(URI uri, ResourceConfig configuration, boolean start) throws ProcessingException {
        return JettyHttpContainerFactory.createServer(uri, null, ContainerFactory.createContainer(JettyHttpContainer.class, configuration), start);
    }

    public static Server createServer(URI uri, ResourceConfig config, boolean start, Object parentContext) {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer(config, parentContext), start);
    }

    public static Server createServer(URI uri, ResourceConfig config, Object parentContext) {
        return JettyHttpContainerFactory.createServer(uri, null, new JettyHttpContainer(config, parentContext), true);
    }

    public static Server createServer(URI uri, SslContextFactory.Server sslContextFactory, ResourceConfig config) throws ProcessingException {
        JettyHttpContainer container = ContainerFactory.createContainer(JettyHttpContainer.class, config);
        return JettyHttpContainerFactory.createServer(uri, sslContextFactory, container, true);
    }

    public static Server createServer(URI uri, SslContextFactory.Server sslContextFactory, JettyHttpContainer handler, boolean start) {
        throw new ProcessingException(LocalizationMessages.NOT_SUPPORTED());
    }
}

