/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DockerClient {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors.Conn.Clients.Docker");
    private static final int BYTES_IN_ONE_GB = 0x40000000;
    private static final int MIN_CPU_SHARES = 2;
    private static final int MIN_MEMORY_SIZE_GB = 1;
    private com.github.dockerjava.api.DockerClient internalDockerClient;

    private DockerClient() {
    }

    public static DockerClient build(DockerClientConfig config) {
        LOGGER.info("Creating DockerClient from build method");
        DockerClient dc = new DockerClient();
        dc.internalDockerClient = DockerClientBuilder.getInstance((DockerClientConfig)config).build();
        return dc;
    }

    public List<Container> getContainersList() {
        ArrayList<Container> l = new ArrayList<Container>();
        l.addAll(this.getStoppedContainersList());
        l.addAll(this.getRunningContainersList());
        l.addAll((Collection)this.internalDockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withStatusFilter(Arrays.asList("restarting")).exec());
        return l;
    }

    public List<Container> getRunningContainersList() {
        ArrayList<Container> l = new ArrayList<Container>();
        l.addAll((Collection)this.internalDockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withStatusFilter(Arrays.asList("running")).exec());
        return l;
    }

    public List<Container> getStoppedContainersList() {
        ArrayList<Container> l = new ArrayList<Container>();
        l.addAll((Collection)this.internalDockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withStatusFilter(Arrays.asList("created", "paused", "exited")).exec());
        return l;
    }

    public void removeStoppedContainers() {
        List<Container> containersList = this.getStoppedContainersList();
        for (Container c : containersList) {
            this.removeContainer(c.getId());
        }
    }

    public void removeAllContainers() {
        List<Container> containersList = this.getStoppedContainersList();
        for (Container c : containersList) {
            this.removeContainer(c.getId());
        }
    }

    public void stopAllContainers() {
        List<Container> runningContainers = this.getRunningContainersList();
        for (Container c : runningContainers) {
            this.stopContainer(c.getId());
        }
    }

    public void startContainer(String containerId) {
        this.internalDockerClient.startContainerCmd(containerId).exec();
    }

    public void restartContainer(String containerId) {
        this.internalDockerClient.restartContainerCmd(containerId).exec();
    }

    public InspectContainerResponse inspectContainer(String containerId) {
        return this.internalDockerClient.inspectContainerCmd(containerId).withContainerId(containerId).exec();
    }

    public NetworkSettings getNetworkSettings(String containerId) {
        return this.inspectContainer(containerId).getNetworkSettings();
    }

    public int getMemoryGB(String containerId) {
        Long mem = this.inspectContainer(containerId).getHostConfig().getMemory();
        return (int)(mem / 0x40000000L);
    }

    public int getCpuShares(String containerId) {
        return this.inspectContainer(containerId).getHostConfig().getCpuShares();
    }

    public int getDiskSize(String containerId) {
        Integer size = this.inspectContainer(containerId).getSizeRootFs();
        return size == null ? 0 : size;
    }

    public String getIpAddress(String containerId) {
        return this.inspectContainer(containerId).getNetworkSettings().getIpAddress();
    }

    public String createContainer(String image, String containerName, int[] exposedPorts, int reqCpuShares, float reqMemoryGB, String ... cmd) {
        ArrayList<ExposedPort> exposedPortsList = new ArrayList<ExposedPort>();
        for (int p : exposedPorts) {
            exposedPortsList.add(new ExposedPort(p));
        }
        CreateContainerCmd ccc = this.internalDockerClient.createContainerCmd(image).withName(containerName).withCmd(cmd).withCpuShares(Integer.valueOf(Math.max(2, reqCpuShares))).withMemory(Long.valueOf(Math.max(1L, (long)(reqMemoryGB * 1.0737418E9f)))).withExposedPorts(exposedPortsList);
        CreateContainerResponse ccr = ccc.exec();
        return ccr.getId();
    }

    public String createContainer(String image, String containerName, int[] exposedPorts, String ... cmd) {
        ArrayList<ExposedPort> exposedPortsList = new ArrayList<ExposedPort>();
        for (int p : exposedPorts) {
            exposedPortsList.add(new ExposedPort(p));
        }
        CreateContainerCmd ccc = this.internalDockerClient.createContainerCmd(image).withName(containerName).withCmd(cmd).withExposedPorts(exposedPortsList);
        CreateContainerResponse ccr = ccc.exec();
        return ccr.getId();
    }

    public String createContainer(String image, String containerName, String ... cmd) {
        return this.createContainer(image, containerName, new int[0], cmd);
    }

    public Container getContainerByName(String containerName) {
        List<Container> containers = this.getContainersList();
        for (Container c : containers) {
            String cName = c.getNames()[0].replace("/", "");
            if (!containerName.equals(cName)) continue;
            return c;
        }
        return null;
    }

    public Container getContainerById(String containerId) {
        List<Container> containers = this.getContainersList();
        for (Container c : containers) {
            if (!containerId.equals(c.getId())) continue;
            return c;
        }
        return null;
    }

    public void stopContainer(String containerId) {
        this.internalDockerClient.stopContainerCmd(containerId).exec();
    }

    public void removeContainer(String containerId) {
        RemoveContainerCmd rcc = this.internalDockerClient.removeContainerCmd(containerId).withForce(Boolean.valueOf(true));
        rcc.exec();
    }

    public com.github.dockerjava.api.DockerClient getInternalDockerClient() {
        return this.internalDockerClient;
    }
}

