/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.jclouds;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import es.bsc.conn.clients.exceptions.ConnClientException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecloud.GoogleCredentialsFromJson;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.jclouds.sshj.config.SshjSshClientModule;

public class JCloudsClient {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors.Conn.Clients.JClouds");
    public static final Map<String, ProviderMetadata> appProviders = Maps.uniqueIndex((Iterable)Providers.viewableAs(ComputeServiceContext.class), (Function)Providers.idFunction());
    public static final Map<String, ApiMetadata> apiProviders = Maps.uniqueIndex((Iterable)Apis.viewableAs(ComputeServiceContext.class), (Function)Apis.idFunction());
    public static final Set<String> allKeys = ImmutableSet.copyOf((Iterable)Iterables.concat(appProviders.keySet(), apiProviders.keySet()));
    private final ComputeServiceContext context;
    private final ComputeService computeService;

    public JCloudsClient(String user, String credential, String provider, String endpoint) throws ConnClientException {
        LOGGER.info("Creating JClouds Client");
        if (!allKeys.contains(provider)) {
            throw new ConnClientException("Provider is not in the list. Available providers are: " + allKeys);
        }
        ContextBuilder contextBuilder = ContextBuilder.newBuilder((String)provider);
        if (endpoint != null && !endpoint.isEmpty()) {
            contextBuilder = contextBuilder.endpoint(endpoint);
        }
        String credentialStr = this.extractCredential(credential);
        this.context = (ComputeServiceContext)contextBuilder.credentials(user, credentialStr).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule())).buildView(ComputeServiceContext.class);
        this.computeService = this.context.getComputeService();
    }

    private String extractCredential(String credential) {
        File f = new File(credential);
        if (f.exists()) {
            if (credential.endsWith(".json")) {
                return JCloudsClient.getCredentialFromJsonKeyFile(credential);
            }
            return credential;
        }
        return credential;
    }

    private static String getCredentialFromJsonKeyFile(String filename) {
        try {
            String fileContents = Files.toString((File)new File(filename), (Charset)Charsets.UTF_8);
            GoogleCredentialsFromJson credentialSupplier = new GoogleCredentialsFromJson(fileContents);
            return ((Credentials)credentialSupplier.get()).credential;
        }
        catch (IOException e) {
            LOGGER.error("Exception reading private key from '%s': " + filename, (Throwable)e);
            return null;
        }
    }

    public Set<? extends NodeMetadata> createVMS(String groupName, int numVMs, Template template) throws RunNodesException {
        return this.computeService.createNodesInGroup(groupName, numVMs, template);
    }

    public Set<? extends Location> getLocations() {
        return this.computeService.listAssignableLocations();
    }

    public Set<? extends Image> getImages() {
        return this.computeService.listImages();
    }

    public Set<? extends Hardware> getHardwareProfiles() {
        return this.computeService.listHardwareProfiles();
    }

    public Set<? extends ComputeMetadata> getNodes() {
        return this.computeService.listNodes();
    }

    public Template createTemplate(String hwID, String imageID, TemplateOptions options) {
        TemplateBuilder templateBuilder = this.computeService.templateBuilder();
        if (hwID != null) {
            templateBuilder.hardwareId(hwID);
        }
        if (imageID != null) {
            templateBuilder.imageId(imageID);
        }
        if (options != null) {
            templateBuilder.options(options);
        }
        return templateBuilder.build();
    }

    public Template createTemplate(Double minCores, Double minDisk, Integer minRam, String imageID, TemplateOptions options) {
        TemplateBuilder templateBuilder = this.computeService.templateBuilder();
        if (minCores != null) {
            templateBuilder.minCores(minCores.doubleValue());
        }
        if (minDisk != null) {
            templateBuilder.minDisk(minDisk.doubleValue());
        }
        if (minRam != null) {
            templateBuilder.minRam(minRam.intValue());
        }
        if (imageID != null) {
            templateBuilder.imageId(imageID);
        }
        if (options != null) {
            templateBuilder.options(options);
        }
        return templateBuilder.build();
    }

    public Template createTemplate(Double minCores, Double minDisk, Integer minRam, TemplateOptions options, Predicate<Image> arg0) {
        TemplateBuilder templateBuilder = this.computeService.templateBuilder();
        if (minCores != null) {
            templateBuilder.minCores(minCores.doubleValue());
        }
        if (minDisk != null) {
            templateBuilder.minDisk(minDisk.doubleValue());
        }
        if (minRam != null) {
            templateBuilder.minRam(minRam.intValue());
        }
        templateBuilder.imageMatches(arg0);
        if (options != null) {
            templateBuilder.options(options);
        }
        return templateBuilder.build();
    }

    public Set<? extends NodeMetadata> destroyAllNodesInGroup(String groupName) {
        return this.computeService.destroyNodesMatching(Predicates.and((Predicate)Predicates.not((Predicate)NodePredicates.TERMINATED), (Predicate)NodePredicates.inGroup((String)groupName)));
    }

    public void destroyNode(String nodeID) {
        this.computeService.destroyNode(nodeID);
    }

    public static String getCredentialFromFile(String filename) throws IOException {
        return Files.toString((File)new File(filename), (Charset)Charsets.UTF_8);
    }

    public static LoginCredentials getCurrentUserLoginForCommandExecution() throws IOException {
        String user = System.getProperty("user.name");
        String privateKey = Files.toString((File)new File(System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_rsa"), (Charset)Charsets.UTF_8);
        return LoginCredentials.builder().user(user).privateKey(privateKey).build();
    }

    public NodeMetadata getNode(String id) {
        return this.computeService.getNodeMetadata(id);
    }
}

