/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.mesos.framework;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.mesos.Protos;

public class MesosTask {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors.Conn.Clients.Mesos.Task");
    private List<Protos.Resource> requirements;
    private Protos.TaskState state;
    private Map<Protos.TaskState, Semaphore> waitSems;
    private String ip;
    private String id;
    private String imageName;
    private String dockerCommand;
    private int retries;

    public MesosTask(String id, String imageName, String dockerCommand, Protos.TaskState state, List<Protos.Resource> requirements) {
        this.id = id;
        this.imageName = imageName;
        this.dockerCommand = dockerCommand;
        this.state = state;
        this.requirements = requirements;
        this.waitSems = new EnumMap<Protos.TaskState, Semaphore>(Protos.TaskState.class);
        this.retries = 0;
    }

    public String getId() {
        return this.id;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getDockerCommand() {
        return this.dockerCommand;
    }

    public List<Protos.Resource> getRequirements() {
        return this.requirements;
    }

    public Protos.TaskState getState() {
        return this.state;
    }

    public void setState(Protos.TaskState state) {
        this.state = state;
        this.releaseSem(state);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getRetries() {
        return this.retries;
    }

    public synchronized void incrementRetries() {
        ++this.retries;
    }

    public void addWait(Protos.TaskState state, Semaphore sem) {
        this.waitSems.put(state, sem);
    }

    public String toString() {
        return String.format("[Task %s] state: %s", this.id, this.state.toString());
    }

    private void releaseSem(Protos.TaskState state) {
        if (this.waitSems.containsKey(state)) {
            LOGGER.debug("Release semaphore " + this.waitSems.get(state).toString() + " for state " + state.toString() + ", task " + this.id);
            this.waitSems.get(state).release();
            this.waitSems.remove(state);
        }
    }
}

