/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.slurm;

import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.slurm.JobDescription;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlurmClient {
    private static final Logger LOGGER = LogManager.getLogger((String)"integratedtoolkit.Connectors.Conn.Clients.SLURM");
    private static final String EXPECTED_RESULT = "Submitted batch job ";
    private static final String DESCRIBE_CMD = "Describe CMD: ";
    private static final String ERROR_DESCRIBE_CMD = "Error on Describe CMD";
    private final String mainJobId;
    private final String masterId;
    private Map<String, String> nodeToJobId = new HashMap<String, String>();
    private Map<String, List<String>> jobIdToNodes = new HashMap<String, List<String>>();
    private final int initialNodes;

    public SlurmClient(String masterId) {
        LOGGER.info("Initializing SLURM Client");
        List<String> nodeIds = this.parseNodes();
        this.initialNodes = nodeIds.size();
        this.masterId = masterId;
        this.mainJobId = System.getenv("SLURM_JOB_ID");
        if (this.mainJobId != null && nodeIds != null && !nodeIds.isEmpty()) {
            this.jobIdToNodes.put(this.mainJobId, nodeIds);
            for (String nodeId : nodeIds) {
                this.nodeToJobId.put(nodeId, this.mainJobId);
            }
        } else {
            LOGGER.error("ERROR no SLURM_JOB_ID defined SLURM client will not work");
        }
    }

    public int getInitialNodes() {
        return this.initialNodes;
    }

    private List<String> parseNodes() {
        String slurmNL = System.getenv("SLURM_JOB_NODELIST");
        LinkedList<String> list = new LinkedList<String>();
        if (slurmNL != null) {
            JobDescription.parseNodelist(slurmNL, list);
        }
        return list;
    }

    public JobDescription getJobDescription(String jobId) throws ConnClientException {
        String cmd = "scontrol show JobId=" + jobId;
        try {
            LOGGER.debug(DESCRIBE_CMD + cmd);
            return new JobDescription(this.executeCmd(cmd));
        }
        catch (ConnClientException ie) {
            LOGGER.error(ERROR_DESCRIBE_CMD, (Throwable)ie);
            throw new ConnClientException((Exception)((Object)ie));
        }
    }

    public String getJobStatus(String jobId) throws ConnClientException {
        String cmd = "sacct -j" + jobId + "-n -P -o status ";
        try {
            LOGGER.debug(DESCRIBE_CMD + cmd);
            return this.executeCmd(cmd);
        }
        catch (ConnClientException ie) {
            LOGGER.error(ERROR_DESCRIBE_CMD, (Throwable)ie);
            throw new ConnClientException((Exception)((Object)ie));
        }
    }

    public void cancelJob(String jobId) throws ConnClientException {
        String cmd = "scancel " + jobId;
        try {
            LOGGER.debug(DESCRIBE_CMD + cmd);
            this.executeCmd(cmd);
        }
        catch (ConnClientException ie) {
            LOGGER.error(ERROR_DESCRIBE_CMD, (Throwable)ie);
            throw new ConnClientException((Exception)((Object)ie));
        }
    }

    public void deleteCompute(String resourceId) throws ConnClientException {
        if (!resourceId.equals(this.masterId)) {
            String nodeJobId = this.nodeToJobId.get(resourceId);
            this.nodeToJobId.remove(resourceId);
            String args = "NodeList=" + this.masterId;
            Set<String> nodeList = this.nodeToJobId.keySet();
            int nodes = 1;
            for (String node : nodeList) {
                if (node.equals(this.masterId)) continue;
                args = args.concat("," + node);
                ++nodes;
            }
            args = args.concat(" NumNodes=" + nodes);
            String cmd = "scontrol update JobId=" + this.mainJobId + " " + args;
            try {
                this.executeCmd(cmd);
            }
            catch (ConnClientException e) {
                LOGGER.warn("Cannot update job " + this.mainJobId + " with " + args, (Throwable)e);
            }
            if (nodeJobId != null) {
                List<String> nodesInJob = this.jobIdToNodes.get(nodeJobId);
                nodesInJob.remove(resourceId);
                if (nodesInJob.isEmpty()) {
                    this.jobIdToNodes.remove(nodeJobId);
                    try {
                        this.cancelJob(nodeJobId);
                    }
                    catch (ConnClientException e) {
                        LOGGER.warn("Cannot cancel job " + nodeJobId + " from resource " + resourceId, (Throwable)e);
                    }
                } else {
                    LOGGER.warn("Job " + nodeJobId + " is not empty. Skiping job cancel ");
                }
            } else {
                LOGGER.warn("JobId for resource " + resourceId + " does not exist");
            }
        } else {
            LOGGER.warn("Trying to remove master node. It is not allowed");
        }
    }

    public String createCompute(JobDescription jobDesc, String script) throws ConnClientException {
        String cmd = "sbatch --dependency=expand:" + this.mainJobId + " " + jobDesc.generateRequest() + " " + script;
        LOGGER.debug("Create CMD: " + cmd);
        return this.parseJobIDFormCreationOutput(this.executeCmd(cmd));
    }

    private String parseJobIDFormCreationOutput(String executeResult) throws ConnClientException {
        if (executeResult.startsWith(EXPECTED_RESULT)) {
            return executeResult.substring(EXPECTED_RESULT.length());
        }
        throw new ConnClientException("Results is not starting as expected. Current: \"" + executeResult + "\" does not starts with \"" + EXPECTED_RESULT + "\"");
    }

    public void addNodesToMain(String jobId, JobDescription jdesc) throws ConnClientException {
        List<String> nodeIds = jdesc.getNodeList();
        this.jobIdToNodes.put(jobId, nodeIds);
        for (String nodeId : nodeIds) {
            this.nodeToJobId.put(nodeId, jobId);
        }
        String args = "NodeList=" + this.masterId;
        Set<String> nodeList = this.nodeToJobId.keySet();
        int nodes = 1;
        for (String node : nodeList) {
            if (node.equals(this.masterId)) continue;
            args = args.concat("," + node);
            ++nodes;
        }
        args = args.concat(" NumNodes=" + nodes);
        String cmd = "scontrol update JobId=" + this.mainJobId + " " + args;
        LOGGER.debug("Update job CMD: " + cmd);
        try {
            this.executeCmd(cmd);
        }
        catch (ConnClientException cce) {
            LOGGER.warn("Error updating job " + this.mainJobId + " with " + args);
            throw cce;
        }
    }

    private String executeCmd(String cmd) throws ConnClientException {
        try {
            String line;
            LOGGER.info("Execute CMD: " + cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader stdInput1 = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError1 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            LOGGER.debug("Execute CMD Output:");
            StringBuilder cmdResult = new StringBuilder();
            while ((line = stdInput1.readLine()) != null) {
                LOGGER.debug(line);
                cmdResult.append(line);
            }
            LOGGER.error("Execute CMD Error:");
            while ((line = stdError1.readLine()) != null) {
                LOGGER.error(line);
            }
            p.waitFor();
            LOGGER.info("Excute CMD exitValue: " + p.exitValue());
            LOGGER.info("__________________________________________");
            return cmdResult.toString();
        }
        catch (IOException | InterruptedException e) {
            throw new ConnClientException(e);
        }
    }
}

