/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.slurm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobDescription {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors.Conn.Clients.SLURM");
    private static final String TRES = "TRES";
    public static final String NUM_NODES = "NumNodes";
    public static final String NUM_CPUS = "NumCPUs";
    public static final String CPUS_TASK = "CPUs/Task";
    public static final String MEM = "mem";
    public static final String GRES = "Gres";
    private static final String NULL = "(null)";
    public static final String NODE_LIST = "NodeList";
    private Map<String, String> jobProperties;
    private List<String> nodeList = new LinkedList<String>();

    public JobDescription(String description) {
        description = description.replaceAll("\n", "");
        String[] pars = description.split(" ");
        if (pars != null && pars.length > 0) {
            this.jobProperties = new HashMap<String, String>(pars.length);
            for (String par : pars) {
                int eqIndex = par.indexOf(61);
                if (eqIndex < 0) continue;
                String key = par.substring(0, eqIndex);
                String value = par.substring(eqIndex + 1);
                if (key.equals(TRES)) {
                    this.parseTREC(value);
                    continue;
                }
                if (NODE_LIST.equals(key)) {
                    LOGGER.debug("Parsing node list: " + value);
                    JobDescription.parseNodelist(value, this.nodeList);
                    continue;
                }
                if (value.equals(NULL)) {
                    value = "";
                }
                this.jobProperties.put(key, value);
            }
        }
    }

    public JobDescription(Map<String, String> jobProp) {
        this.jobProperties = jobProp;
    }

    public static void parseNodelist(String value, List<String> nodeList2) {
        if ((value = value.replaceAll("\n", "").trim()) == null || value.isEmpty()) {
            LOGGER.warn("No nodelist in the description");
            return;
        }
        int startPosition = 0;
        int nextStBrack = value.indexOf(91);
        int nextEndBrack = value.indexOf(93);
        int nextComma = value.indexOf(44);
        String nodeGroup = value;
        while (nextComma > 0) {
            if (nextStBrack > 0 && nextEndBrack > 0 && nextComma > nextStBrack) {
                nodeGroup = value.substring(startPosition, nextEndBrack + 1);
                startPosition = nextEndBrack + 2;
            } else {
                nodeGroup = value.substring(startPosition, nextComma);
                startPosition = nextComma + 1;
            }
            if (nodeGroup != null && !nodeGroup.isEmpty()) {
                if (nodeGroup.contains("[")) {
                    JobDescription.manageNodeGroup(nodeGroup, nodeList2);
                } else {
                    nodeList2.add(nodeGroup);
                }
            }
            nextStBrack = value.indexOf(startPosition, 91);
            nextEndBrack = value.indexOf(startPosition, 93);
            nextComma = value.indexOf(startPosition, 44);
        }
        if (startPosition >= 0 && startPosition < value.length()) {
            nodeGroup = value.substring(startPosition);
            if (nodeGroup.contains("[")) {
                JobDescription.manageNodeGroup(nodeGroup, nodeList2);
            } else {
                nodeList2.add(nodeGroup);
            }
        }
    }

    private static void manageNodeGroup(String nodeGroup, List<String> nodeList2) {
        String nodeRoot = nodeGroup.substring(0, nodeGroup.indexOf(91));
        String numliststr = nodeGroup.substring(nodeGroup.indexOf(91) + 1, nodeGroup.indexOf(93));
        if (numliststr.contains(",")) {
            String[] numList;
            for (String num : numList = numliststr.split(",")) {
                if (num.contains("-")) {
                    JobDescription.addNodesInInterval(num, nodeRoot, nodeList2);
                    continue;
                }
                nodeList2.add(nodeRoot + num);
            }
        } else if (numliststr.contains("-")) {
            JobDescription.addNodesInInterval(numliststr, nodeRoot, nodeList2);
        }
    }

    private static void addNodesInInterval(String numInterval, String nodeRoot, List<String> nodeList2) {
        int init = Integer.parseInt(numInterval.substring(0, numInterval.indexOf(45)));
        int end = Integer.parseInt(numInterval.substring(numInterval.indexOf(45) + 1));
        for (int i = init; i <= end; ++i) {
            nodeList2.add(nodeRoot + i);
        }
    }

    private void parseTREC(String value) {
        String[] trecs = value.split(",");
        if (trecs != null && trecs.length > 0) {
            for (String trec : trecs) {
                int eqIndex = trec.indexOf(61);
                this.jobProperties.put(trec.substring(0, eqIndex), trec.substring(eqIndex + 1));
            }
        }
    }

    public String generateRequest() {
        String gresStr;
        int cpusTask;
        StringBuilder sb = new StringBuilder();
        String nodes = this.jobProperties.get(NUM_NODES);
        if (nodes == null || nodes.isEmpty()) {
            LOGGER.warn("Num nodes for SLURM is not defined. Seting one by default");
            nodes = "1";
        }
        sb.append("-N" + nodes);
        String cpusStr = this.jobProperties.get(NUM_CPUS);
        String cpusTaskStr = this.jobProperties.get(CPUS_TASK);
        if (cpusTaskStr == null || cpusTaskStr.isEmpty()) {
            cpusTask = 1;
        } else {
            cpusTask = Integer.parseInt(cpusTaskStr);
            sb.append(" --cpus_per_task=" + cpusTask);
        }
        int cpus = cpusStr == null || cpusStr.isEmpty() ? cpusTask : Integer.parseInt(cpusStr);
        int tasks = cpus / cpusTask;
        sb.append(" -n" + tasks);
        String memStr = this.jobProperties.get(MEM);
        if (memStr != null && !memStr.isEmpty()) {
            sb.append(" --mem=" + memStr);
        }
        if ((gresStr = this.jobProperties.get(GRES)) != null && !gresStr.isEmpty()) {
            sb.append(" --gres=" + gresStr);
        }
        return sb.toString();
    }

    public List<String> getNodeList() {
        return this.nodeList;
    }

    public String getProperty(String string) {
        return this.jobProperties.get(string);
    }
}

