/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.clients.vmm;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.vmm.types.VMDescription;
import es.bsc.conn.clients.vmm.types.VMRequest;
import es.bsc.conn.clients.vmm.types.VMs;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class VMMClient {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Connectors.Conn.Clients.VMM");
    private static final String ERROR_INCORRECT_RETURN = "Incorrect return code: ";
    private static final int MIN_CPUS = 1;
    private static final int MIN_RAM = 512;
    private static final int MIN_DISK = 1;
    private final Client client = new Client();
    private final WebResource resource;

    public VMMClient(String url) {
        this.resource = this.client.resource(url);
    }

    public String createVM(String name, String image, int cpus, int ramMb, int diskGb, String applicationId, String preferredHost, boolean needsFloatingIp) throws ConnClientException {
        int usableCPUs = cpus >= 1 ? cpus : 1;
        int usableRamMb = ramMb >= 512 ? ramMb : 512;
        int usableDiskGb = diskGb >= 1 ? diskGb : 1;
        VMRequest vm = new VMRequest(name, image, usableCPUs, usableRamMb, usableDiskGb, applicationId, preferredHost, needsFloatingIp);
        VMs vms = new VMs();
        vms.addVM(vm);
        JSONObject obj = new JSONObject((Object)vms);
        LOGGER.debug("Submitting vm creation ... \n" + obj.toString());
        ClientResponse cr = (ClientResponse)this.resource.path("vms").type(MediaType.APPLICATION_JSON_TYPE).post(ClientResponse.class, (Object)obj.toString());
        if (cr.getStatus() == Response.Status.OK.getStatusCode()) {
            String id = null;
            try {
                String s = (String)cr.getEntity(String.class);
                JSONObject res = new JSONObject(s);
                id = (String)res.getJSONArray("ids").getJSONObject(0).get("id");
            }
            catch (JSONException je) {
                throw new ConnClientException((Exception)((Object)je));
            }
            LOGGER.debug("VM submitted with id " + id);
            return id;
        }
        String msg = ERROR_INCORRECT_RETURN + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase();
        LOGGER.error(msg);
        throw new ConnClientException(msg);
    }

    public VMDescription getVMDescription(String id) throws ConnClientException {
        LOGGER.debug("Getting vm description ...");
        ClientResponse cr = (ClientResponse)this.resource.path("vms").path(id).get(ClientResponse.class);
        if (cr.getStatus() == Response.Status.OK.getStatusCode()) {
            String s = (String)cr.getEntity(String.class);
            LOGGER.debug("Obtained description " + s);
            try {
                return new VMDescription(new JSONObject(s));
            }
            catch (JSONException je) {
                throw new ConnClientException((Exception)((Object)je));
            }
        }
        String msg = ERROR_INCORRECT_RETURN + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase();
        LOGGER.error(msg);
        throw new ConnClientException(msg);
    }

    public void deleteVM(String vmId) throws ConnClientException {
        LOGGER.debug("Getting vm destruction ...");
        ClientResponse cr = (ClientResponse)this.resource.path("vms").path(vmId).delete(ClientResponse.class);
        if (cr.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            String msg = ERROR_INCORRECT_RETURN + cr.getStatus() + "." + cr.getClientResponseStatus().getReasonPhrase();
            LOGGER.error(msg);
            throw new ConnClientException(msg);
        }
    }
}

