/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.direct;

import es.bsc.conn.Connector;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Direct
extends Connector {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.Direct");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final int CREATION_TIME = 15000;
    private final Map<TestMachineId, HardwareDescription> idToHardwareRequest = Collections.synchronizedMap(new HashMap());
    private final Map<TestMachineId, SoftwareDescription> idToSoftwareRequest = Collections.synchronizedMap(new HashMap());

    public Direct(Map<String, String> props) throws ConnException {
        super(props);
    }

    @Override
    public Object create(String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        LOGGER.info("Creating VirtualResource with name " + requestName);
        if (DEBUG) {
            LOGGER.debug("- Associated Hardware Description: " + hd);
            LOGGER.debug("- Associated Software Description: " + sd);
        }
        TestMachineId tid = new TestMachineId();
        this.idToHardwareRequest.put(tid, hd);
        this.idToSoftwareRequest.put(tid, sd);
        LOGGER.info("- VR with name " + requestName + " was assigned to ID = " + tid);
        return tid;
    }

    @Override
    public Object[] createMultiple(int replicas, String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        Object[] envIds = new TestMachineId[replicas];
        for (int i = 0; i < replicas; ++i) {
            envIds[i] = (TestMachineId)this.create(requestName, hd, sd, prop, starterCMD);
        }
        return envIds;
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        TestMachineId tid = (TestMachineId)id;
        LOGGER.info("Waiting for creation of " + tid);
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        VirtualResource vr = new VirtualResource();
        vr.setId(id);
        vr.setIp(this.idToHardwareRequest.get((TestMachineId)id).getType());
        vr.setHd(this.idToHardwareRequest.get((TestMachineId)id));
        vr.setSd(this.idToSoftwareRequest.get((TestMachineId)id));
        LOGGER.info("Created machine with ID = " + tid);
        return vr;
    }

    @Override
    public void destroy(Object id) {
        TestMachineId tid = (TestMachineId)id;
        LOGGER.info("Deleting VirtualResource " + tid);
        this.idToHardwareRequest.remove(tid);
        this.idToSoftwareRequest.remove(tid);
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        LOGGER.info("Getting price slot");
        return 0.0f;
    }

    @Override
    public void close() {
        LOGGER.info("Closing");
    }

    private static class TestMachineId {
        private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
        private final int id = NEXT_ID.getAndIncrement();

        private TestMachineId() {
        }

        public String toString() {
            return "TestMachineId-" + this.id;
        }
    }
}

