/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.AuthCmd;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CommitCmd;
import com.github.dockerjava.api.command.ConnectToNetworkCmd;
import com.github.dockerjava.api.command.ContainerDiffCmd;
import com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateImageCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateVolumeCmd;
import com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectExecCmd;
import com.github.dockerjava.api.command.InspectImageCmd;
import com.github.dockerjava.api.command.InspectNetworkCmd;
import com.github.dockerjava.api.command.InspectVolumeCmd;
import com.github.dockerjava.api.command.KillContainerCmd;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.ListNetworksCmd;
import com.github.dockerjava.api.command.ListVolumesCmd;
import com.github.dockerjava.api.command.LoadImageCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PauseContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.RemoveContainerCmd;
import com.github.dockerjava.api.command.RemoveImageCmd;
import com.github.dockerjava.api.command.RemoveNetworkCmd;
import com.github.dockerjava.api.command.RemoveVolumeCmd;
import com.github.dockerjava.api.command.RenameContainerCmd;
import com.github.dockerjava.api.command.RestartContainerCmd;
import com.github.dockerjava.api.command.SaveImageCmd;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.StopContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerCmd;
import com.github.dockerjava.api.command.UnpauseContainerCmd;
import com.github.dockerjava.api.command.UpdateContainerCmd;
import com.github.dockerjava.api.command.VersionCmd;
import com.github.dockerjava.api.command.WaitContainerCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.jaxrs.AttachContainerCmdExec;
import com.github.dockerjava.jaxrs.AuthCmdExec;
import com.github.dockerjava.jaxrs.BuildImageCmdExec;
import com.github.dockerjava.jaxrs.CommitCmdExec;
import com.github.dockerjava.jaxrs.ConnectToNetworkCmdExec;
import com.github.dockerjava.jaxrs.ContainerDiffCmdExec;
import com.github.dockerjava.jaxrs.CopyArchiveFromContainerCmdExec;
import com.github.dockerjava.jaxrs.CopyArchiveToContainerCmdExec;
import com.github.dockerjava.jaxrs.CopyFileFromContainerCmdExec;
import com.github.dockerjava.jaxrs.CreateContainerCmdExec;
import com.github.dockerjava.jaxrs.CreateImageCmdExec;
import com.github.dockerjava.jaxrs.CreateNetworkCmdExec;
import com.github.dockerjava.jaxrs.CreateVolumeCmdExec;
import com.github.dockerjava.jaxrs.DisconnectFromNetworkCmdExec;
import com.github.dockerjava.jaxrs.EventsCmdExec;
import com.github.dockerjava.jaxrs.ExecCreateCmdExec;
import com.github.dockerjava.jaxrs.ExecStartCmdExec;
import com.github.dockerjava.jaxrs.InfoCmdExec;
import com.github.dockerjava.jaxrs.InspectContainerCmdExec;
import com.github.dockerjava.jaxrs.InspectExecCmdExec;
import com.github.dockerjava.jaxrs.InspectImageCmdExec;
import com.github.dockerjava.jaxrs.InspectNetworkCmdExec;
import com.github.dockerjava.jaxrs.InspectVolumeCmdExec;
import com.github.dockerjava.jaxrs.KillContainerCmdExec;
import com.github.dockerjava.jaxrs.ListContainersCmdExec;
import com.github.dockerjava.jaxrs.ListImagesCmdExec;
import com.github.dockerjava.jaxrs.ListNetworksCmdExec;
import com.github.dockerjava.jaxrs.ListVolumesCmdExec;
import com.github.dockerjava.jaxrs.LoadImageCmdExec;
import com.github.dockerjava.jaxrs.LogContainerCmdExec;
import com.github.dockerjava.jaxrs.PauseContainerCmdExec;
import com.github.dockerjava.jaxrs.PingCmdExec;
import com.github.dockerjava.jaxrs.PullImageCmdExec;
import com.github.dockerjava.jaxrs.PushImageCmdExec;
import com.github.dockerjava.jaxrs.RemoveContainerCmdExec;
import com.github.dockerjava.jaxrs.RemoveImageCmdExec;
import com.github.dockerjava.jaxrs.RemoveNetworkCmdExec;
import com.github.dockerjava.jaxrs.RemoveVolumeCmdExec;
import com.github.dockerjava.jaxrs.RenameContainerCmdExec;
import com.github.dockerjava.jaxrs.RestartContainerCmdExec;
import com.github.dockerjava.jaxrs.SaveImageCmdExec;
import com.github.dockerjava.jaxrs.SearchImagesCmdExec;
import com.github.dockerjava.jaxrs.StartContainerCmdExec;
import com.github.dockerjava.jaxrs.StatsCmdExec;
import com.github.dockerjava.jaxrs.StopContainerCmdExec;
import com.github.dockerjava.jaxrs.TagImageCmdExec;
import com.github.dockerjava.jaxrs.TopContainerCmdExec;
import com.github.dockerjava.jaxrs.UnixConnectionSocketFactory;
import com.github.dockerjava.jaxrs.UnpauseContainerCmdExec;
import com.github.dockerjava.jaxrs.UpdateContainerCmdExec;
import com.github.dockerjava.jaxrs.VersionCmdExec;
import com.github.dockerjava.jaxrs.WaitContainerCmdExec;
import com.github.dockerjava.jaxrs.filter.JsonClientFilter;
import com.github.dockerjava.jaxrs.filter.ResponseStatusExceptionFilter;
import com.github.dockerjava.jaxrs.filter.SelectiveLoggingFilter;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.WebTarget;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyDockerCmdExecFactory
implements DockerCmdExecFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyDockerCmdExecFactory.class.getName());
    private Client client;
    private WebTarget baseResource;
    private Integer readTimeout = null;
    private Integer connectTimeout = null;
    private Integer maxTotalConnections = null;
    private Integer maxPerRouteConnections = null;
    private ClientRequestFilter[] clientRequestFilters = null;
    private ClientResponseFilter[] clientResponseFilters = null;
    private DockerClientConfig dockerClientConfig;
    private PoolingHttpClientConnectionManager connManager = null;

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(dockerClientConfig, "config was not specified");
        this.dockerClientConfig = dockerClientConfig;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.connectorProvider(new ApacheConnectorProvider());
        clientConfig.property("jersey.config.disableAutoDiscovery", true);
        clientConfig.register((Class)ResponseStatusExceptionFilter.class);
        clientConfig.register((Class)JsonClientFilter.class);
        clientConfig.register((Class)JacksonJsonProvider.class);
        clientConfig.register(new SelectiveLoggingFilter(LOGGER, true));
        if (this.readTimeout != null) {
            clientConfig.property("jersey.config.client.readTimeout", this.readTimeout);
        }
        if (this.connectTimeout != null) {
            clientConfig.property("jersey.config.client.connectTimeout", this.connectTimeout);
        }
        if (this.clientResponseFilters != null) {
            for (ClientResponseFilter clientResponseFilter : this.clientResponseFilters) {
                if (clientResponseFilter == null) continue;
                clientConfig.register(clientResponseFilter);
            }
        }
        if (this.clientRequestFilters != null) {
            for (ClientRequestFilter clientRequestFilter : this.clientRequestFilters) {
                if (clientRequestFilter == null) continue;
                clientConfig.register(clientRequestFilter);
            }
        }
        URI originalUri = dockerClientConfig.getDockerHost();
        String protocol = null;
        SSLContext sslContext = null;
        try {
            SSLConfig sslConfig = dockerClientConfig.getSSLConfig();
            if (sslConfig != null) {
                sslContext = sslConfig.getSSLContext();
            }
        }
        catch (Exception ex) {
            throw new DockerClientException("Error in SSL Configuration", ex);
        }
        protocol = sslContext != null ? "https" : "http";
        if (!originalUri.getScheme().equals("unix")) {
            try {
                originalUri = new URI(originalUri.toString().replaceFirst("tcp", protocol));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.configureProxy(clientConfig, protocol);
        }
        this.connManager = new PoolingHttpClientConnectionManager(this.getSchemeRegistry(originalUri, sslContext)){

            @Override
            public void close() {
                super.shutdown();
            }

            @Override
            public void shutdown() {
            }
        };
        if (this.maxTotalConnections != null) {
            this.connManager.setMaxTotal(this.maxTotalConnections);
        }
        if (this.maxPerRouteConnections != null) {
            this.connManager.setDefaultMaxPerRoute(this.maxPerRouteConnections);
        }
        clientConfig.property("jersey.config.apache.client.connectionManager", this.connManager);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig(clientConfig);
        if (sslContext != null) {
            clientBuilder.sslContext(sslContext);
        }
        this.client = clientBuilder.build();
        this.baseResource = this.client.target(this.sanitizeUrl(originalUri).toString()).path(dockerClientConfig.getApiVersion().asWebPathPart());
    }

    private URI sanitizeUrl(URI originalUri) {
        if (originalUri.getScheme().equals("unix")) {
            return UnixConnectionSocketFactory.sanitizeUri(originalUri);
        }
        return originalUri;
    }

    private void configureProxy(ClientConfig clientConfig, String protocol) {
        List<Proxy> proxies = ProxySelector.getDefault().select(this.dockerClientConfig.getDockerHost());
        for (Proxy proxy : proxies) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            if (address == null) continue;
            String hostname = address.getHostName();
            int port = address.getPort();
            clientConfig.property("jersey.config.client.proxy.uri", "http://" + hostname + ":" + port);
            String httpProxyUser = System.getProperty(protocol + ".proxyUser");
            if (httpProxyUser == null) continue;
            clientConfig.property("jersey.config.client.proxy.username", httpProxyUser);
            String httpProxyPassword = System.getProperty(protocol + ".proxyPassword");
            if (httpProxyPassword == null) continue;
            clientConfig.property("jersey.config.client.proxy.password", httpProxyPassword);
        }
    }

    private Registry<ConnectionSocketFactory> getSchemeRegistry(URI originalUri, SSLContext sslContext) {
        RegistryBuilder<ConnectionSocketFactory> registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", PlainConnectionSocketFactory.getSocketFactory());
        if (sslContext != null) {
            registryBuilder.register("https", new SSLConnectionSocketFactory(sslContext));
        }
        registryBuilder.register("unix", new UnixConnectionSocketFactory(originalUri));
        return registryBuilder.build();
    }

    protected WebTarget getBaseResource() {
        Preconditions.checkNotNull(this.baseResource, "Factory not initialized, baseResource not set. You probably forgot to call init()!");
        return this.baseResource;
    }

    protected DockerClientConfig getDockerClientConfig() {
        Preconditions.checkNotNull(this.dockerClientConfig, "Factor not initialized, dockerClientConfig not set. You probably forgot to call init()!");
        return this.dockerClientConfig;
    }

    @Override
    public AuthCmd.Exec createAuthCmdExec() {
        return new AuthCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InfoCmd.Exec createInfoCmdExec() {
        return new InfoCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PingCmd.Exec createPingCmdExec() {
        return new PingCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public VersionCmd.Exec createVersionCmdExec() {
        return new VersionCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PullImageCmd.Exec createPullImageCmdExec() {
        return new PullImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PushImageCmd.Exec createPushImageCmdExec() {
        return new PushImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SaveImageCmd.Exec createSaveImageCmdExec() {
        return new SaveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateImageCmd.Exec createCreateImageCmdExec() {
        return new CreateImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public LoadImageCmd.Exec createLoadImageCmdExec() {
        return new LoadImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public SearchImagesCmd.Exec createSearchImagesCmdExec() {
        return new SearchImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveImageCmd.Exec createRemoveImageCmdExec() {
        return new RemoveImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListImagesCmd.Exec createListImagesCmdExec() {
        return new ListImagesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectImageCmd.Exec createInspectImageCmdExec() {
        return new InspectImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListContainersCmd.Exec createListContainersCmdExec() {
        return new ListContainersCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateContainerCmd.Exec createCreateContainerCmdExec() {
        return new CreateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StartContainerCmd.Exec createStartContainerCmdExec() {
        return new StartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectContainerCmd.Exec createInspectContainerCmdExec() {
        return new InspectContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecCreateCmd.Exec createExecCmdExec() {
        return new ExecCreateCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveContainerCmd.Exec createRemoveContainerCmdExec() {
        return new RemoveContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public WaitContainerCmd.Exec createWaitContainerCmdExec() {
        return new WaitContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public AttachContainerCmd.Exec createAttachContainerCmdExec() {
        return new AttachContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ExecStartCmd.Exec createExecStartCmdExec() {
        return new ExecStartCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectExecCmd.Exec createInspectExecCmdExec() {
        return new InspectExecCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public LogContainerCmd.Exec createLogContainerCmdExec() {
        return new LogContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyArchiveFromContainerCmd.Exec createCopyArchiveFromContainerCmdExec() {
        return new CopyArchiveFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyFileFromContainerCmd.Exec createCopyFileFromContainerCmdExec() {
        return new CopyFileFromContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CopyArchiveToContainerCmd.Exec createCopyArchiveToContainerCmdExec() {
        return new CopyArchiveToContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StopContainerCmd.Exec createStopContainerCmdExec() {
        return new StopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ContainerDiffCmd.Exec createContainerDiffCmdExec() {
        return new ContainerDiffCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public KillContainerCmd.Exec createKillContainerCmdExec() {
        return new KillContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UpdateContainerCmd.Exec createUpdateContainerCmdExec() {
        return new UpdateContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RenameContainerCmd.Exec createRenameContainerCmdExec() {
        return new RenameContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RestartContainerCmd.Exec createRestartContainerCmdExec() {
        return new RestartContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CommitCmd.Exec createCommitCmdExec() {
        return new CommitCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public BuildImageCmd.Exec createBuildImageCmdExec() {
        return new BuildImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TopContainerCmd.Exec createTopContainerCmdExec() {
        return new TopContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public TagImageCmd.Exec createTagImageCmdExec() {
        return new TagImageCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public PauseContainerCmd.Exec createPauseContainerCmdExec() {
        return new PauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public UnpauseContainerCmd.Exec createUnpauseContainerCmdExec() {
        return new UnpauseContainerCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public EventsCmd.Exec createEventsCmdExec() {
        return new EventsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public StatsCmd.Exec createStatsCmdExec() {
        return new StatsCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateVolumeCmd.Exec createCreateVolumeCmdExec() {
        return new CreateVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectVolumeCmd.Exec createInspectVolumeCmdExec() {
        return new InspectVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveVolumeCmd.Exec createRemoveVolumeCmdExec() {
        return new RemoveVolumeCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListVolumesCmd.Exec createListVolumesCmdExec() {
        return new ListVolumesCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ListNetworksCmd.Exec createListNetworksCmdExec() {
        return new ListNetworksCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public InspectNetworkCmd.Exec createInspectNetworkCmdExec() {
        return new InspectNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public CreateNetworkCmd.Exec createCreateNetworkCmdExec() {
        return new CreateNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public RemoveNetworkCmd.Exec createRemoveNetworkCmdExec() {
        return new RemoveNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public ConnectToNetworkCmd.Exec createConnectToNetworkCmdExec() {
        return new ConnectToNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public DisconnectFromNetworkCmd.Exec createDisconnectFromNetworkCmdExec() {
        return new DisconnectFromNetworkCmdExec(this.getBaseResource(), this.getDockerClientConfig());
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull(this.client, "Factory not initialized. You probably forgot to call init()!");
        this.client.close();
        this.connManager.close();
    }

    public JerseyDockerCmdExecFactory withReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public JerseyDockerCmdExecFactory withConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public JerseyDockerCmdExecFactory withMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public JerseyDockerCmdExecFactory withMaxPerRouteConnections(Integer maxPerRouteConnections) {
        this.maxPerRouteConnections = maxPerRouteConnections;
        return this;
    }

    public JerseyDockerCmdExecFactory withClientResponseFilters(ClientResponseFilter ... clientResponseFilter) {
        this.clientResponseFilters = clientResponseFilter;
        return this;
    }

    public JerseyDockerCmdExecFactory withClientRequestFilters(ClientRequestFilter ... clientRequestFilters) {
        this.clientRequestFilters = clientRequestFilters;
        return this;
    }
}

