/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Image;
import org.jclouds.ec2.compute.domain.RegionAndName;

@Singleton
public class ImagesToRegionAndIdMap
implements Function<Iterable<? extends Image>, Map<RegionAndName, ? extends Image>> {
    public static Map<RegionAndName, ? extends Image> imagesToMap(Iterable<? extends Image> input) {
        return new ImagesToRegionAndIdMap().apply(input);
    }

    @Override
    public Map<RegionAndName, ? extends Image> apply(Iterable<? extends Image> input) {
        return Maps.uniqueIndex(input, new Function<Image, RegionAndName>(){

            @Override
            public RegionAndName apply(Image from) {
                Preconditions.checkState(from.getLocation() != null, "in ec2, image locations cannot be null; typically, they are Region-scoped");
                String[] segments = from.getId().split("/");
                Preconditions.checkArgument(segments.length == 2, "Wrong form for AWS image ID: " + from);
                return new RegionAndName(segments[0], segments[1]);
            }
        });
    }
}

