/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public class Tag {
    protected final String resourceId;
    protected final String resourceType;
    protected final String key;
    protected final Optional<String> value;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Tag.builder().fromTag(this);
    }

    protected Tag(String resourceId, String resourceType, String key, Optional<String> value) {
        this.resourceId = Preconditions.checkNotNull(resourceId, "resourceId");
        this.resourceType = Preconditions.checkNotNull(resourceType, "resourceType");
        this.key = Preconditions.checkNotNull(key, "key");
        this.value = Preconditions.checkNotNull(value, "value");
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.resourceId, this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equal(this.resourceId, other.resourceId) && Objects.equal(this.key, other.key);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("resourceId", this.resourceId).add("resourceType", this.resourceType).add("key", this.key).add("value", this.value.orNull());
    }

    public static class Builder {
        protected String resourceId;
        protected String resourceType;
        protected String key;
        protected Optional<String> value = Optional.absent();

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = Optional.fromNullable(value);
            return this;
        }

        public Tag build() {
            return new Tag(this.resourceId, this.resourceType, this.key, this.value);
        }

        public Builder fromTag(Tag in) {
            return this.resourceId(in.getResourceId()).resourceType(in.getResourceType()).key(in.getKey()).value(in.getValue().orNull());
        }
    }

    public static final class ResourceType {
        public static final String CUSTOMER_GATEWAY = "customer-gateway";
        public static final String DHCP_OPTIONS = "dhcp-options";
        public static final String IMAGE = "image";
        public static final String INSTANCE = "instance";
        public static final String INTERNET_GATEWAY = "internet-gateway";
        public static final String NETWORK_ACL = "network-acl";
        public static final String RESERVED_INSTANCES = "reserved-instances";
        public static final String ROUTE_TABLE = "route-table";
        public static final String SECURITY_GROUP = "security-group";
        public static final String SNAPSHOT = "snapshot";
        public static final String SPOT_INSTANCES_REQUEST = "spot-instances-request";
        public static final String SUBNET = "subnet";
        public static final String VOLUME = "volume";
        public static final String VPC = "vpc";
        public static final String VPN_CONNECTION = "vpn-connection";
        public static final String VPN_GATEWAY = "vpn-gateway";

        private ResourceType() {
            throw new AssertionError((Object)"intentionally unimplemented");
        }
    }
}

