/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.util.Map;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.ConfiguresNodeStore;

@ConfiguresNodeStore
@Beta
public class CacheNodeStoreModule
extends AbstractModule {
    private final LoadingCache<String, Node> backing;

    public CacheNodeStoreModule(LoadingCache<String, Node> backing) {
        this.backing = Preconditions.checkNotNull(backing, "backing");
    }

    public CacheNodeStoreModule(Map<String, Node> backing) {
        this(CacheBuilder.newBuilder().build(CacheLoader.from(Functions.forMap(backing))));
        for (String node : backing.keySet()) {
            this.backing.getUnchecked(node);
        }
    }

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<LoadingCache<String, Node>>(){}).toInstance(this.backing);
        this.bind(new TypeLiteral<Supplier<LoadingCache<String, Node>>>(){}).toInstance(Suppliers.ofInstance(this.backing));
    }
}

