/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.io.BaseEncoding;
import javax.inject.Inject;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindS3UploadPolicyAndSignature
implements Binder {
    private final FormSigner.FormSignerV2 signer;

    @Inject
    BindS3UploadPolicyAndSignature(FormSigner.FormSignerV2 signer) {
        this.signer = signer;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String encodedJson = BaseEncoding.base64().encode(Preconditions.checkNotNull(input, "json").toString().getBytes(Charsets.UTF_8));
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("Storage.S3.UploadPolicy", encodedJson);
        String signature = this.signer.sign(encodedJson);
        builder.put("Storage.S3.UploadPolicySignature", signature);
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceFormParams(builder.build())).build();
    }
}

