/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;

@Singleton
public class CreateUniqueKeyPair
extends CacheLoader<RegionAndName, KeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    protected final GroupNamingConvention.Factory namingConvention;

    @Inject
    public CreateUniqueKeyPair(NovaApi novaApi, GroupNamingConvention.Factory namingConvention) {
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    @Override
    public KeyPair load(RegionAndName regionAndName) {
        String regionId = Preconditions.checkNotNull(regionAndName, "regionAndName").getRegion();
        String prefix = regionAndName.getName();
        Optional<KeyPairApi> api = this.novaApi.getKeyPairApi(regionId);
        Preconditions.checkArgument(api.isPresent(), "Key pairs are required, but the extension is not available in region %s!", regionId);
        this.logger.debug(">> creating keyPair region(%s) prefix(%s)", regionId, prefix);
        KeyPair keyPair = null;
        while (keyPair == null) {
            try {
                keyPair = api.get().create(this.namingConvention.createWithoutPrefix().uniqueNameForGroup(prefix));
            }
            catch (IllegalStateException e) {}
        }
        this.logger.debug("<< created keyPair(%s)", keyPair.getName());
        return keyPair;
    }
}

